<?php

namespace App\Http\Controllers\Api\V1\User;

use Exception;
use App\Common\Method\Response;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\BaseController;
use App\Services\User\RechargeLogModel;
use App\Services\User\RechargeRateModel;
use App\Http\Resources\User\RechargeRateResources;
use App\ToolsClass\RedisTool;
use App\Common\Enum\RedisEnum;
use App\Services\User\MoneyLogModel;
/** 充值 */
class RechargeController extends BaseController
{
    public function getRechargeRate(RechargeRateModel $rechargeRateModel)
    {
        // 筛选
        $where = [];
        $list = $rechargeRateModel
            ->where($where)
            ->orderByRaw('weigh desc')
            ->paginate($this->request->per_page ?? 20);
        $list = $rechargeRateModel->page($list);
        $list['data'] = RechargeRateResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }
    
    public function goPay(RechargeRateModel $rechargeRateModel,
                            RechargeLogModel $rechargeLogModel,
                            RedisTool $redis,
                            MoneyLogModel $moneyLogModel
    )
    {
        $user = auth('api')->user();
        $key = RedisEnum::RECHARGE . $user->id;
        $rechargeRateId = $this->request->id;
        if($redis->block($key)){
            //充值金额选项
            $rechargeRate = $rechargeRateModel->where('id',$rechargeRateId)->first();
            if (!$rechargeRate) {
                return $this->unlock($redis, $key)->error('充值选项不存在!');
            }
            if($user->level != 1){
                //不是主播就正常走支付
            DB::beginTransaction();
                try {
                    // 组合支付数据
                    $pay = $rechargeLogModel->pay($user, $rechargeRate->rmb, $rechargeRate->money);
                    if (!$pay) {
                        DB::rollBack();
                        return $this->unlock($redis, $key)->error(Response::getMessage());
                    }
                    $returnData = [
                        'order_sn' => $pay->out_trade_no,
                        'pay_money' => $pay->pay_money,
                        'pay_type'=>3
                    ];
                    DB::commit();
                    return $this->unlock($redis, $key)->success('下单成功!', $returnData);
                } catch (Exception $e) {
                    DB::rollBack();
                    return $this->unlock($redis, $key)->error('下单失败!');
                }
            }else{
                $res = $moneyLogModel->log($user->userinfo,$rechargeRate->money,$moneyLogModel::TYPE_12);
                if($res){
                    return $this->unlock($redis, $key)->success('充值成功!'); 
                }
            }
            // 开启事务提交
        }
        return $this->error('请勿重复提交');
    }
}
