<?php

namespace App\Http\Controllers\Api\V1\User;

use App\Services\User\UsersModel;

use App\Models\Admin\Configuration;
use App\Http\Controllers\BaseController;
use App\Services\User\MoneyLogModel;
use App\Services\User\GoldLogModel;
use App\ToolsClass\WeChat\MiniProgramTool;
use App\Http\Requests\Api\User\UserRequest;
use App\Services\User\BindLogModel;
use App\Services\Order\OrderListModel;
use App\Services\User\TreeModel;
use App\ToolsClass\WeChat\Qrcode;
use App\Services\Order\OrderModel;
use App\Services\User\InfoModel;
use App\Services\User\AddressModel;
use App\Services\User\CoinLogModel;
use App\Services\User\RechargeLogModel;
use App\Services\User\WithdrawModel;
use Illuminate\Support\Facades\DB;

class UserController extends BaseController
{
    /**
     * 获取用户信息
     *
     * @param  \App\Services\User\UsersModel      $model
     * @param  \App\Services\Order\OrderListModel $orderListModel
     */
    public function info(UsersModel $model, OrderListModel $orderListModel, GoldLogModel $goldLogModel, BindLogModel $bindLogModel)
    {
        $user = auth('api')->user();

        // 用户基本信息
        $data['id'] = $user->id;
        $data['nickName'] = $user->nickName;
        $data['mobile'] = $user->mobile ?? '';
        $data['avatar'] = $user->avatar;
        $data['money'] = $user->userinfo->money ?? 0;
        $data['coin'] = $user->userinfo->coin ?? 0;
        $data['gold'] = $user->userinfo->gold ?? 0;
        $data['invite_code'] = $user->invite_code;
        $data['level'] = $user->level;
        // 盒柜数量
        $where = [
            ['user_id', '=', $user->id],
        ];
        $data['box_1'] = $orderListModel->where($where)
            ->where('status', $orderListModel::STA_0)
            ->whereIn('type', [$orderListModel::TYPE_1, $orderListModel::TYPE_2])
            ->count();
        $data['box_2'] = $orderListModel->where($where)
            ->where('status', $orderListModel::STA_1)
            ->whereIn('type', [$orderListModel::TYPE_1, $orderListModel::TYPE_2])
            ->count();
        $data['box_3'] = $orderListModel->where($where)
            ->where('status', $orderListModel::STA_2)
            ->whereIn('type', [$orderListModel::TYPE_1, $orderListModel::TYPE_2])
            ->count();
        $data['box_4'] = $orderListModel->where($where)
            ->where('status', $orderListModel::STA_3)
            ->whereIn('type', [$orderListModel::TYPE_1, $orderListModel::TYPE_2])
            ->count();
        $qrcode = [
            // 'scene'=>'invite_code='.$user->invite_code, //前端传递的用户id参数
            'page'=>'pages/box/box', //小程序页面，必须是已经发布审核通过上线的小程序页面
            'width'=>300, //二维码宽度
            'check_path'=>false, //是否检查路径
        ];
        $scene = 'invite_code='.$user->invite_code;
        $data['share_url'] = env('APP_URL') .'/api/v1/share?invite_code=' . $user->invite_code;
        $data['codeShareUrl'] = (new MiniProgramTool)->getQrcode($scene,$qrcode,$user->id);
        //总收益金额
        $data['total_money'] = $goldLogModel->where('user_id',$user->id)->where('type',5)->sum('change');
        //总下级人数
        $treeModel = new TreeModel();
        $data['total_xjnum'] = $treeModel->downList($user->id, 3);
        return $this->success('请求成功', $data);
    }

    /**
     * 更新用户信息
     *
     * @param  \App\Services\User\UsersModel           $usersModel
     * @param  \App\Http\Requests\Api\User\UserRequest $validate
     */
    public function updateInfo(
        UsersModel $usersModel,
        UserRequest $validate
    ) {
        $user = auth('api')->user();
        $user = $usersModel->where('id', $user->id)->first();
        $type = $this->request->type;
        // 验证
        if (!$validate->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        // 修改头像
        if ($type == 1) {
            $user->avatar = $this->request->avatar;
        }
        // 修改昵称
        if ($type == 2) {
            $user->nickName = $this->request->nickName;
        }
        if ($user->save()) {
            return $this->success('修改成功!');
        }
        return $this->error('修改失败!');
    }

    /**
     * 更新用户手机号
     *
     * @param  \App\ToolsClass\WeChat\MiniProgramTool $miniProgramTool
     * @param  \App\Services\User\UsersModel          $usersModel
     */
    public function updateMobile(
        MiniProgramTool $miniProgramTool,
        UsersModel $usersModel
    ) {
        $user = auth('api')->user();
        $user = $usersModel->where('id', $user->id)->first();
        $mobileCode = $this->request->mobileCode;
        $mobile = (new Qrcode)->mobile($mobileCode);
        if (!$mobile) {
            return $this->error('手机号获取失败!');
        }
        if ($user->mobile == $mobile) {
            return $this->error('您已绑定该手机号!');
        }
        $log = $usersModel->where('mobile', $mobile)->first();
        if ($log) {
            $res = $this->updateUserInfo($log->id,$user->id);
            $user->mobile = $mobile;
            $log->mobile = '';
            $log->save();
            $user->save();
            if($res){
                return $this->success('信息更新成功!');
            }
        }
        $user->mobile = $mobile;
        if (!$user->save()) {
            return $this->error('信息更新失败!');
        }
        return $this->success('信息更新成功!');
    }
    
    public function getShareCode()
    {
        $invite = $this->model->where("admin_id", $this->auth->id)->column("code");


       $this->view->assign("invite", (new Qrcode)->getQrcode($data));
        return $this->view->fetch();
    }
    
    public function updateUserInfo($oldUserId,$newUserId)
    {
        $userInfo = new InfoModel();
        $addressModel = new AddressModel();
        $bindLogModel = new BindLogModel();
        $coinLogModel = new CoinLogModel();
        $goldLogModel = new GoldLogModel();
        $moneyLogModel = new MoneyLogModel();
        $rechargeLogModel = new RechargeLogModel();
        $threeModel = new TreeModel();
        $withdrawModel = new WithdrawModel();
        $orderListModel = new OrderListModel();
        DB::beginTransaction();
        try{
            $userInfo->where('user_id',$newUserId)->delete();
            $userInfo->where('user_id',$oldUserId)->update(['user_id'=>$newUserId]);
            $addressModel->where('user_id',$oldUserId)->update(['user_id'=>$newUserId]);
            $coinLogModel->where('user_id',$oldUserId)->update(['user_id'=>$newUserId]);
            $goldLogModel->where('user_id',$oldUserId)->update(['user_id'=>$newUserId]);
            $moneyLogModel->where('user_id',$oldUserId)->update(['user_id'=>$newUserId]);
            $rechargeLogModel->where('user_id',$oldUserId)->update(['user_id'=>$newUserId]);
			$bindLogModel->where('user_id',$newUserId)->delete();
            $bindLogModel->where('user_id',$oldUserId)->update(['user_id'=>$newUserId]);
            $bindLogModel->where('parent_id',$oldUserId)->update(['parent_id'=>$newUserId]);
            $threeModel->where('user_id',$newUserId)->delete();
            $threeModel->where('user_id',$oldUserId)->update(['user_id'=>$newUserId]);
            $withdrawModel->where('user_id',$oldUserId)->update(['user_id'=>$newUserId]);
            $orderListModel->where('user_id',$oldUserId)->update(['user_id'=>$newUserId]);
            DB::commit();
            return true;
        }catch (Exception $e) {
            DB::rollBack();
            return $this->error('信息更新失败!');
        }
    }
    public function myTeam(BindLogModel $bindLogModel,OrderModel $orderModel, RechargeLogModel $rechargeLogModel)
    {
        $user = auth('api')->user();
        // 时间筛选
        $start = $this->request->start_time;   //开始时间
        $end = $this->request->end_time;       //截至时间
        $time = [
            $start ? strtotime($start.'00:00:00') : mktime(0,0,0,date('m'),date('d')-date('w')+4-7,date('Y')),
            $end ? strtotime($end.'23:59:59') : strtotime(date('Y-m-d').'23:59:59'),
        ];
        $bindUser = $bindLogModel->where('parent_id',$user->id)
                                 ->whereBetween('created_at', $time)
                                 ->get();
        $userLog = [];
        $startUnix = $start ? strtotime($start.'00:00:00') : mktime(0,0,0,date('m'),date('d')-date('w')+4-7,date('Y'));
        $endUnix = $end ? strtotime($end.'23:59:59') : strtotime(date('Y-m-d').'23:59:59');
        $bindLogList = $bindLogModel->where('parent_id',$user->id)
                                //  ->whereBetween('created_at', $timeF)
                                 ->get()
                                 ->toArray();
        $userIds1 = array_column($bindLogList,'user_id');
        for($i = $startUnix; $i < $endUnix; $i += 86400){ // 86400为1天的秒数
            $timeF = [
                $i,
                $i + 86400,
            ];
            
            $bindLog = $bindLogModel->where('parent_id',$user->id)
                                 ->whereBetween('created_at', $timeF)
                                 ->get()
                                 ->toArray();
            $userIds = array_column($bindLog,'user_id');
            
            // 【修改】只统计"发放了佣金的订单"（从 friend_open_log 表查询）
            $orderLog = DB::table('users_friend_open_log')
                ->join('order', 'users_friend_open_log.order_id', '=', 'order.id')
                ->where('users_friend_open_log.user_id', $user->id)  // 代理ID
                ->where('order.status', $orderModel::STA_1)  // 已支付
                ->whereBetween('order.created_at', $timeF)
                ->select('order.id', 'order.pay_money', 'order.created_at')
                ->get()
                ->toArray();
            
            // 转为数组格式（保持和原来一致）
            $orderLog = json_decode(json_encode($orderLog), true);
            
            $rechargeLog = $rechargeLogModel->whereIn('user_id',$userIds1)
                                   ->where('status',$orderModel::STA_1)
                                   ->whereBetween('created_at',$timeF)
                                   ->get()
                                   ->toArray();
            $userLog[date('Y-m-d',$i)]['num'] = count($bindLog);
            $userLog[date('Y-m-d',$i)]['money'] = $this->userMoney($orderLog);
            $userLog[date('Y-m-d',$i)]['recharge_money'] = $this->userMoney($rechargeLog);
            
        }
        ksort($userLog);
        return $this->success('查询成功',$userLog);
        
    }
    public function userMoney($List)
    {
        $totalMoney = 0;
        foreach ($List as $item){
           $totalMoney =  bcadd($item['pay_money'],$totalMoney,2);
        }
        return $totalMoney;
    }
}
