<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class BaseController extends Controller
{
    /**
     * 公共控制器Api
     * @var Request
     */
    protected $request;

    public function __construct()
    {
        $this->request = request();
    }

    /**
     * 返回成功数据
     *
     * @param  string  $msg
     * @param  array   $data
     * @param  integer $code
     */
    public function success($msg = '操作成功', $data = [], $code = 200)
    {
        return response()->json(['code' => $code, 'msg' => $msg, 'data' => $data]);
    }

    /**
     * 返回失败数据
     *
     * @param  string  $msg
     * @param  array   $data
     * @param  integer $code
     */
    public function error($msg = '操作失败', $data = [], $code = 400)
    {
        return response()->json(['code' => $code, 'msg' => $msg, 'data' => $data]);
    }

    /**
     * Redis 乐观锁操作失败回滚
     *
     * @param  object $redis
     * @param  string $key
     */
    public function incre($redis, $key)
    {
        $redis->incre($key, 1);
        return $this;
    }

    /**
     * Redis 悲观锁操作失败回滚
     *
     * @param  object $redis
     * @param  string $key
     */
    public function unlock($redis, $key)
    {
        $redis->unlock($key);
        return $this;
    }
}
