<?php

namespace App\Http\Middleware;

use App\Common\Enum\Common;
use Closure;

// 接口安全校验
class ApiMiddleware
{
    // 白名单
    const LIST = [
        'e97d231ee94ee227539295a58428776c98bc78e0' // 测试使用
    ];

    /**  
     * @param  \Illuminate\Http\Request  $request  
     * @param  \Closure  $next  
     * @return mixed  
     */
    public function handle($request, Closure $next)
    {
        return $next($request);
        // 白名单过滤（DeBug 开启）
        if (env('APP_DEBUG') === true) {
            if (in_array($request->header('whitelist'), self::LIST)) {
                return $next($request);
            }
        }
        //验证签名（DeBug 关闭）
        $timeStamp = $request->header('t');
        if ($timeStamp <= (time() + 5) && $timeStamp > (time() - 5)) {
            $randomStr = $request->header('r');
            $signature = $request->header('s');
            $str = $this->arithmetic($timeStamp, $randomStr); //通过前台传过来的时间戳跟随机数重新按照签名函数进行生成一遍签名
            //然后将传过来签名跟，自己重新生成的签名进行比对
            if ($str == $signature) {
                return $next($request);
            }
        }
        return response()->json(['code' => 1000, 'msg' => '签名错误!', 'data' => []]);
    }

    /**
     * @param $timeStamp 时间戳     1651031271
     * @param $randomStr 随机字符串 iPo3wIp6INsuAx3b
     * @return string 返回签名      7285D082488AE4660B14B26F8FC5E9D1
     */
    private function arithmetic($timeStamp, $randomStr)
    {
        $arr['timeStamp'] = $timeStamp;
        $arr['randomStr'] = $randomStr;
        $arr['token'] = Common::SIGNATURE;
        //按照首字母大小写顺序排序
        sort($arr, SORT_STRING);
        //拼接成字符串
        $str = implode($arr);
        //进行加密
        $signature = sha1($str);
        $signature = md5($signature);
        //转换成大写
        $signature = strtoupper($signature);
        return $signature;
    }
}
