<?php

namespace App\Http\Middleware;

use App\Common\Enum\RedisEnum;
use App\Services\User\UsersModel;
use App\ToolsClass\RedisTool;
use Closure;
use Illuminate\Support\Facades\Auth;
use Tymon\JWTAuth\Exceptions\JWTException;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;
use Tymon\JWTAuth\Exceptions\TokenInvalidException;
use Tymon\JWTAuth\Facades\JWTAuth;
use Tymon\JWTAuth\Http\Middleware\BaseMiddleware;

class ApiTokenMiddleware extends BaseMiddleware
{
    /**  
     * @param  \Illuminate\Http\Request  $request  
     * @param  \Closure  $next  
     * @return mixed  
     */
    public function handle($request, Closure $next)
    {
        try {
            $redis = new RedisTool();
            if (!$user = $this->auth->parseToken()->authenticate()) {  //获取到用户数据，并赋值给$user
                return response()->json(['code' => 1001, 'msg' => '用户不存在!']);
            }
            // 判断 Token 是否一致（一端登录）
            if (env('JWT_SINGLE_SWITCH')) {
                $token = $redis->get(RedisEnum::API_TOKEN . $user->id);
                if (!$token || $this->auth->getToken() != $token) {
                    return response()->json(['code' => 1002, 'msg' => '请重新登录!']);
                }
            }
            // 验证用户状态
            if ($user->status == 2) {
                return response()->json(['code' => 1002, 'msg' => '您已被禁用!']);
            }
            return $next($request);
        } catch (TokenExpiredException $e) {
            //无痛刷新 Token authorization
            try {
                // 刷新用户的 token
                $token = $this->auth->parseToken()->refresh();
                // 使用一次性登录以保证此次请求的成功
                auth('api')->onceUsingId($this->auth->manager()->getPayloadFactory()->buildClaimsCollection()->toPlainArray()['sub']);
                $user = auth('api')->user();
                // Token Redis 存储
                UsersModel::respondWithToken($user, $token);
                return $this->setAuthenticationHeader($next($request), $token);
            } catch (JWTException  $e) {
                return response()->json(['code' => 1002, 'msg' => '请重新登录!']);
            }
        } catch (TokenInvalidException $e) {
            return response()->json(['code' => 1002, 'msg' => 'Token 不正确!']);
        } catch (JWTException $e) {
            return response()->json(['code' => 1002, 'msg' => '缺少 Token!']);
        }
    }
}
