<?php

namespace App\Http\Middleware;

use Closure;
use Spatie\Permission\Exceptions\UnauthorizedException;

// 后台权限检查
class PermissionMiddleware
{
    public function handle($request, Closure $next, $permission, $guard = null)
    {
        // 超级管理员不检测权限
        if (auth()->user()->id == 1) {
            return $next($request);
        }
        if (app('auth')->guard($guard)->guest()) {
            throw UnauthorizedException::notLoggedIn();
        }

        $permissions = is_array($permission)
            ? $permission
            : explode('|', $permission);

        foreach ($permissions as $permission) {
            if (app('auth')->guard($guard)->user()->can($permission)) {
                return $next($request);
            }
        }
        if ($request->isMethod('get')) {
            throw UnauthorizedException::forPermissions($permissions);
        }
        return response()->json(['code' => 400, 'msg' => '暂无权限!', 'data' => []]);
    }
}
