<?php

namespace App\Http\Requests\Admin\Admin;

use Illuminate\Validation\Rule;
use App\Http\Requests\BaseRequest;

class RoleCreateRequest extends BaseRequest
{
    //验证规则
    public function rule()
    {
        return [
            'name'         => ['required', 'string', 'between:1,14', Rule::unique('admin_roles')->ignore(request()->id)],
            'display_name' => ['required']
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'name.required'         => '请填写角色名称',
            'name.string'           => '角色名称参数错误',
            'name.between'          => '角色名称为1~14个字符',
            'name.unique'           => '角色名称已被使用',
            'display_name.required' => '请填写显示名称',
        ];
    }
}
