<?php

namespace App\Http\Requests\Admin\Admin;

use Illuminate\Validation\Rule;
use App\Http\Requests\BaseRequest;

class UserCreateRequest extends BaseRequest
{
    //验证规则
    public function rule()
    {
        return [
            'username' => ['required', 'string', 'between:4,14', Rule::unique('admin_users')->ignore(request()->id)],
            'nickname' => ['required', 'string', 'between:1,14'],
            'email'    => ['required', Rule::unique('admin_users')->ignore(request()->id)],
            'phone'    => ['required', 'numeric', 'regex:/^1[3456789][0-9]{9}$/', Rule::unique('admin_users')->ignore(request()->id)],
            'password' => ['nullable', 'confirmed', 'between:1,16']
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'username.required'  => '请填写用户名',
            'username.string'    => '用户名参数错误',
            'username.between'   => '用户名为4~14个字符',
            'username.unique'    => '用户名已被使用',
            'nickname.required'  => '请填写昵称',
            'nickname.string'    => '昵称参数错误',
            'nickname.between'   => '昵称为1~14个字符',
            'email.required'     => '请填写邮箱',
            'email.unique'       => '邮箱已被使用',
            'email.email'        => '邮箱格式错误',
            'phone.required'     => '请填手机号',
            'phone.numeric'      => '手机号不正确',
            'phone.regex'        => '手机号格式不正确',
            'phone.unique'       => '手机号已被使用',
            'password.between'   => '密码为6~16个字符',
            'password.confirmed' => '两次密码输入不一致',
        ];
    }
}
