<?php

namespace App\Http\Requests\Admin\Box;

use App\Http\Requests\BaseRequest;

// 拆盒机盒子
class BoxRequest extends BaseRequest
{
    //自定义场景
    public $scene = [
        'add'  => [],
        'edit' => [],
    ];

    //验证规则
    public function rule()
    {
        return [
            'thumb'      => ['required'],
            'title'      => ['required', 'string', 'between:1,30'],
            'price'      => ['required', 'numeric', 'min:0'],
            'send_coin'  => ['required', 'integer', 'min:0'],
            'send_money' => ['required', 'numeric', 'min:0'],
            'sort'       => ['required', 'integer', 'between:0,1000'],
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'thumb.required'      => '请上传盒子赏品图',
            'title.required'      => '请填写标题',
            'title.string'        => '标题填写错误',
            'title.between'       => '标题长度为1~30字符',
            'price.required'      => '请填写现价',
            'price.numeric'       => '现价填写错误',
            'price.min'           => '现价最小为0',
            'send_coin.required'  => '请填写赠送积分',
            'send_coin.integer'   => '赠送积分填写错误',
            'send_coin.min'       => '赠送积分最小为0',
            'send_money.required' => '请填写赠送现金',
            'send_money.numeric'  => '赠送现金填写错误',
            'send_money.min'      => '赠送现金最小为0',
            'sort.required'       => '请填写排序值',
            'sort.integer'        => '排序值为正整数',
            'sort.between'        => '排序值为0~1000区间',
        ];
    }
}
