<?php

namespace App\Http\Requests\Admin\Box;

use App\Http\Requests\BaseRequest;

// 抽取方式
class DrawRequest extends BaseRequest
{
    //自定义场景
    public $scene = [
        'add'  => [],
        'edit' => [],
    ];

    //验证规则
    public function rule()
    {
        return [
            'title' => ['required', 'string', 'between:1,30'],
            'times' => ['required', 'integer', 'min:1'],
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'title.required' => '请填写抽取名称',
            'title.string'   => '抽取名称',
            'title.between'  => '抽取名称长度为1~30字符',
            'times.required' => '请填写抽取次数',
            'times.integer'  => '抽取次数填写错误',
            'times.min'      => '抽取次数最小为1',
        ];
    }
}
