<?php

namespace App\Http\Requests\Admin\Complain;

use App\Http\Requests\BaseRequest;

class TypeRequest extends BaseRequest
{
    //自定义场景
    public $scene = [
        'add'  => [],
        'edit' => [],
    ];

    //验证规则
    public function rule()
    {
        return [
            'title' => 'required|string|between:1,10',
            'sort'  => 'required|integer|between:0,255',
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'title.required' => '名称不能为空',
            'title.between'  => '名称长度应该在1~10位之间',
            'title.string'   => '名称格式不正确',
            'sort.required'  => '请填写排序值',
            'sort.integer'   => '排序值填写不正确',
            'sort.between'   => '排序值为0~255之间',
        ];
    }
}
