<?php

namespace App\Http\Requests\Admin\Operate;

use Illuminate\Validation\Rule;
use App\Http\Requests\BaseRequest;
use App\Services\Operate\BannersModel;

// 轮播图
class BannersRequest extends BaseRequest
{
    //自定义场景
    public $scene = [
        'add'  => [],
        'edit' => [],
    ];

    //验证规则
    public function rule()
    {
        return [
            'cat_id'   => ['required', 'integer'],
            'title'    => ['nullable', 'between:1,15'],
            'thumb'    => ['required'],
            'url_type' => ['required', Rule::in(array_keys(BannersModel::$url_type))],
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'cat_id.required'   => '请选择分类',
            'cat_id.integer'    => '分类选择不正确',
            'title.between'     => '标题长度为1~15字符',
            'thumb.required'    => '请上传缩略图',
            'url_type.required' => '请选择跳转类型',
            'url_type.in'       => '跳转类型选择不正确',
        ];
    }
}
