<?php

namespace App\Http\Requests\Admin\Shop;

use App\Http\Requests\BaseRequest;

// 商品
class GoodsRequest extends BaseRequest
{
    //自定义场景
    public $scene = [
        'add'  => [],
        'edit' => [],
    ];

    //验证规则
    public function rule()
    {
        return [
            'title'            => 'required|string|between:1,30',
            'cat_id'           => 'required|integer|min:1',
            'thumb'            => 'required',
            'status'           => 'required|integer|in:1,2',
            'old_price'        => 'required_if:is_attribute,0|nullable|numeric|min:0.01',
            'price'            => 'required_if:is_attribute,0|nullable|numeric|min:0.01',
            'sales'            => 'required_if:is_attribute,0|nullable|numeric|min:0',
            'stock'            => 'required_if:is_attribute,0|nullable|numeric|min:0',
            'skus.*.old_price' => 'required_if:is_attribute,1|numeric|min:0.01',
            'skus.*.price'     => 'required_if:is_attribute,1|numeric|min:0.01',
            'skus.*.sales'     => 'required_if:is_attribute,1|numeric|min:0',
            'skus.*.stock'     => 'required_if:is_attribute,1|numeric|min:0',
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'title.required'               => '请填写商品名称',
            'title.string'                 => '名称填写不正确',
            'title.between'                => '名称长度为1~30字符',
            'cat_id.required'              => '请选择分类',
            'cat_id.integer'               => '分类选择不正确',
            'cat_id.min'                   => '分类选择不正确',
            'thumb.required'               => '请上传轮播图',
            'status.required'              => '请选择状态',
            'status.integer'               => '状态选择不正确',
            'status.in'                    => '状态选择不正确',
            'old_price.required_if'        => '请填写原价',
            'old_price.numeric'            => '原价填写不正确',
            'old_price.min'                => '原价不能小于0.01',
            'price.required_if'            => '请填写现价',
            'price.numeric'                => '现价填写不正确',
            'price.min'                    => '现价不能小于0.01',
            'sales.required_if'            => '请填写销量',
            'sales.integer'                => '销量填写不正确',
            'sales.min'                    => '销量要大于0',
            'stock.required'               => '请填写库存',
            'stock.integer'                => '库存填写不正确',
            'stock.min'                    => '库存要大于0',
            'skus.*.old_price.required_if' => '请填写原价',
            'skus.*.old_price.numeric'     => '原价填写不正确',
            'skus.*.old_price.min'         => '原价不能小于0.01',
            'skus.*.price.required_if'     => '请填写现价',
            'skus.*.price.numeric'         => '现价填写不正确',
            'skus.*.price.min'             => '现价不能小于0.01',
            'skus.*.sales.required_if'     => '请填写销量',
            'skus.*.sales.numeric'         => '请填写销量',
            'skus.*.sales.min'             => '销量不能小于0',
            'skus.*.stock.required_if'     => '请填写库存',
            'skus.*.stock.numeric'         => '请填写库存',
            'skus.*.stock.min'             => '库存不能小于0',
        ];
    }
}
