<?php

namespace App\Http\Requests\Admin\Users;

use App\Http\Requests\BaseRequest;
use App\Rules\MobileRule;

// 发货
class ShipRequest extends BaseRequest
{
    //自定义场景
    public $scene = [
        'send' => ['delivery_id', 'express_num'],
        'edit' => ['name',  'mobile', 'address'],
    ];

    //验证规则
    public function rule()
    {
        return [
            'name'        => 'required|string|between:1,10',
            'mobile'      => ['required', new MobileRule],
            'address'     => 'required|string|between:1,100',
            'delivery_id' => 'required|integer|gt:0',
            'express_num' => ['required', 'string', 'between:1,100'],
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'name.required'        => '请填写收件人姓名',
            'name.string'          => '收件人姓名参数有误',
            'name.between'         => '收件人姓名过长',
            'mobile.required'      => '请填写收件人手机号',
            'address.required'     => '请填写收件人地址',
            'address.string'       => '收件人地址参数错误',
            'address.between'      => '收件人地址过长',
            'delivery_id.required' => '请选择快递',
            'delivery_id.integer'  => '快递参数错误',
            'delivery_id.gt'       => '快递参数错误',
            'express_num.required' => '请填写快递编号',
            'express_num.string'   => '快递编号参数错误',
            'express_num.between'  => '快递编号过长',
        ];
    }
}
