<?php

namespace App\Http\Requests\Api\Luckbox;

use App\Http\Requests\BaseRequest;

class JoinRequest extends BaseRequest
{
    // 自定义验证规则
    public function rule()
    {
        return [
            'num' => ['required', 'integer', 'min:1'],
        ];
    }

    // 自定义验证信息
    public function message()
    {
        return [
            'num.required' => '请选择数量',
            'num.integer'  => '数量选择不正确',
            'num.min'      => '数量最小为1',
        ];
    }
}
