<?php

namespace App\Http\Requests\Api\User;

use App\Rules\MobileRule;
use Illuminate\Validation\Rule;
use App\Http\Requests\BaseRequest;
use App\Services\User\AddressModel;

/** 用户地址验证 */
class AddressRequest extends BaseRequest
{
    // 自定义验证规则
    public function rule()
    {
        return [
            'id'        => ['present', 'nullable', 'integer', 'gt:0'],
            'name'      => ['required', 'string', 'between:2,10'],
            'mobile'    => ['required', 'string', new MobileRule],
            'province'  => ['required', 'string', 'between:1,30'],
            'city'      => ['present', 'nullable', 'string', 'between:1,30'],
            'area'      => ['required', 'string', 'between:1,50'],
            'site'      => ['required', 'string', 'between:1,50'],
            'status'    => ['required', 'integer', Rule::in(array_keys(AddressModel::$status))],
        ];
    }

    // 自定义验证信息
    public function message()
    {
        return [
            // ID
            'id.present' => '缺少ID参数',
            'id.integer' => 'ID填写错误',
            'id.gt'      => 'ID填写错误',
            // 联系人
            'name.required' => '请填写联系人',
            'name.string'   => '联系人填写有误',
            'name.between'  => '联系人长度为2~10位',
            // 手机号
            'mobile.required' => '请填写联系人手机号',
            'mobile.string'   => '手机号填写有误',
            // 省
            'province.required' => '请选择省份',
            'province.string'   => '省份填写错误',
            'province.between'  => '省份填写错误',
            // 市
            'city.present' => '缺少市参数',
            'city.string'  => '市填写错误',
            'city.between' => '市填写错误',
            // 区
            'area.required' => '请选择区',
            'area.string'   => '区选择错误',
            'area.between'  => '区选择错误',
            // 详细地址
            'site.required' => '请填写详细地址',
            'site.string'   => '详细地址填写错误',
            'site.between'  => '详细地址过长',
            // 状态
            'status.required' => '请选择是否默认',
            'status.integer'  => '默认填写错误',
            'status.in'       => '默认选择不正确',
        ];
    }
}
