<?php

namespace App\Http\Requests\Api\User;

use App\Http\Requests\BaseRequest;

// 提现验证
class WithdrawRequst extends BaseRequest
{
    // 自定义验证规则
    public function rule()
    {
        return [
            'money'  => ['required', 'numeric', 'min:100', 'max:3000'],
            'qrcode' => ['required'],
        ];
    }

    // 自定义验证信息
    public function message()
    {
        return [
            'money.required'  => '请填写提现金额',
            'money.numeric'   => '金额填写不正确',
            'money.min'       => '金额不得少于100.00￥',
            'money.max'       => '金额不得大于3000.00￥',
            'qrcode.required' => '请上传收款二维码',
        ];
    }
}
