<?php

namespace App\Http\Resources\Box;

use App\Services\Box\MarkModel;
use Illuminate\Http\Resources\Json\JsonResource;

class BoxInfoResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        // 概率数据
        $markList = MarkModel::orderByRaw('sort asc')->select(['id', 'title', 'color', 'icon'])->get();
        if ($markList) {
            foreach ($markList as $v) {
                $v->rate = $this->mark_rate[$v->id] ?? '0.00';
            }
        }
        return [
            'id'        => $this->id,
            'title'     => $this->title,
            'thumb'     => $this->thumb,
            'price'     => $this->price,
            'send_coin' => $this->send_coin,
            'markList'  => $markList,
        ];
    }
}
