<?php

namespace App\Http\Resources\Box;

use App\Services\Box\AwardModel;
use Illuminate\Http\Resources\Json\JsonResource;

class BoxListResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        // 商品数据
        $awardList = AwardModel::where(['box_id' => $this->id])
            ->orderByRaw('mark_id asc,id desc')
            ->get()->pluck('thumb');
        return [
            'id'        => $this->id,
            'title'     => $this->title,
            'thumb'     => $this->thumb,
            'price'     => $this->price,
            'send_coin' => $this->send_coin,
            // 'sales'     => formatNum($this->sales),
            'sales'     => $this->sales,
            'awardList' => $awardList,
            'animation' => $this->animation,
        ];
    }
}
