<?php

namespace App\Http\Resources\Luckbox;

use App\Services\Luckbox\JoinModel;
use Illuminate\Http\Resources\Json\JsonResource;

class LogListResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $user = auth('api')->user();
        // 我的盲盒数量
        $box_num = JoinModel::where(['user_id' => $user->id, 'term_id' => $this->id])->sum('num');
        return [
            'id'          => $this->id,
            'title'       => $this->title,
            'join_num'    => $this->join_num,
            'luck_number' => $this->luck_number,
            'box_num' => $box_num,
        ];
    }
}
