<?php

namespace App\Http\Resources\Shop;

use App\Services\Shop\CollectModel;
use App\Services\Shop\SkuModel;
use App\Services\Shop\SpecModel;
use App\Services\Shop\SpecValModel;
use Illuminate\Http\Resources\Json\JsonResource;

class GoodsInfoResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $user = auth('api')->user();
        // 是否收藏
        $collectModel = new CollectModel();
        $is_collect = 2;
        if ($user) {
            $is_collect = $collectModel->isCollect($user, $this->id) ? 1 : 2;
        }
        // 收藏人数
        $collect_num = $collectModel->whereRaw("FIND_IN_SET($this->id,path)")->count();
        // 规格数据
        $attr = SpecModel::with('valinfo')->where(['goods_id' => $this->id])->orderByRaw('id asc')->get();
        $sku = SkuModel::where(['goods_id' => $this->id, 'status' => 1])->orderByRaw('id asc')->get();
        return [
            'id'        => $this->id,
            'title'     => $this->title,
            'thumb'     => $this->thumb,
            'old_price' => $this->old_price,
            'price'     => $this->price,
            'editor'    => $this->editor,
            'stock'     => $this->stock,
            'sales'     => formatNum($this->sales),
            'is_collect' => $is_collect,
            'collect_num' => $collect_num,
            'attr'        => $attr,
            'sku'         => $sku,
        ];
    }
}
