<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Resources\Json\JsonResource;

class MoneyResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'     => $this->id,
            'change' => formatPrice($this->change),
            'desc'   => $this->desc,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
        ];
    }
}
