<?php

namespace App\Listeners;

use Monolog\Logger;
use Monolog\Handler\RotatingFileHandler;
use Illuminate\Database\Events\QueryExecuted;

class QueryListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  QueryExecuted  $event
     * @return void
     */
    public function handle(QueryExecuted $event)
    {
        try {
            $sql = str_replace("?", "'%s'", $event->sql);
            foreach ($event->bindings as $i => $binding) {
                if ($binding instanceof \DateTime) {
                    $event->bindings[$i] = $binding->format('\'Y-m-d H:i:s\'');
                } else {
                    if (is_string($binding)) {
                        $event->bindings[$i] = "'$binding'";
                    }
                }
            }
            $log = vsprintf($sql, $event->bindings);
            $log = $log . '  [ RunTime:' . $event->time . 'ms ] ';
            $logger = new Logger('sql');
            $logger->pushHandler(new RotatingFileHandler(storage_path('logs/sql/sql.log')))->info($log);
        } catch (\Exception $exception) {
            //
        }
    }
}
