<?php

namespace App\Models\Box;

use App\Models\BaseModel;
use Illuminate\Database\Eloquent\SoftDeletes;

// 拆盒机盒子
class Box extends BaseModel
{
    use SoftDeletes;

    protected $table = "box";

    public $timestamps = true;

    protected $casts = [
        'mark_rate' => 'array',
    ];

    /** 缩略图修改器 */
    public function setThumbAttribute($value)
    {
        $this->attributes['thumb'] = imageUrl($value, false);
    }
    public function getThumbAttribute($value)
    {
        return imageUrl($value);
    }

    /** 富文本修改器 */
    public function setEditorAttribute($value)
    {
        if ($value) {
            $data = getSrc($value);
            if ($data) {
                foreach ($data as $v) {
                    $value = str_ireplace($v, imageUrl($v, false), $value);
                }
            }
        }
        $this->attributes['editor'] = $value;
    }
    public function getEditorAttribute($value)
    {
        if ($value) {
            $data = getSrc($value);
            if ($data) {
                foreach ($data as $v) {
                    $value = str_ireplace($v, imageUrl($v), $value);
                }
            }
        }
        return $value;
    }
}
