<?php

namespace App\Models\Operate;

use App\Models\BaseModel;

// 轮播图
class Banners extends BaseModel
{
    protected $table = "operate_banners";

    public $timestamps = true;

    /** 缩略图修改器 */
    public function setThumbAttribute($value)
    {
        $this->attributes['thumb'] = imageUrl($value, false);
    }
    /** 缩略图访问器 */
    public function getThumbAttribute($value)
    {
        return imageUrl($value);
    }

    /** 富文本修改器 */
    public function setEditorAttribute($value)
    {
        if ($value) {
            $data = getSrc($value);
            if ($data) {
                foreach ($data as $v) {
                    $value = str_ireplace($v, imageUrl($v, false), $value);
                }
            }
        }
        $this->attributes['editor'] = $value;
    }
    public function getEditorAttribute($value)
    {
        if ($value) {
            $data = getSrc($value);
            if ($data) {
                foreach ($data as $v) {
                    $value = str_ireplace($v, imageUrl($v), $value);
                }
            }
        }
        return $value;
    }
}
