<?php

namespace App\Models\Order;

use App\Models\BaseModel;
use App\Models\Box\Mark;
use App\Models\User\Users;
use Illuminate\Database\Eloquent\SoftDeletes;

// 商品
class OrderList extends BaseModel
{
    use SoftDeletes;

    protected $table = "order_list";

    public $timestamps = true;

    /** 缩略图 */
    public function setThumbAttribute($value)
    {
        $this->attributes['thumb'] = imageUrl($value, false);
    }
    public function getThumbAttribute($value)
    {
        return imageUrl($value);
    }

    /** 关联用户表 */
    public function userinfo()
    {
        return $this->belongsTo(Users::class, 'user_id', 'id')->withDefault();
    }

    /** 关联订单表 */
    public function orderinfo()
    {
        return $this->belongsTo(Order::class, 'order_id', 'id')->withDefault();
    }

    /** 关联奖品等级表 */
    public function markinfo()
    {
        return $this->belongsTo(Mark::class, 'mark_id', 'id')->withDefault();
    }

    /** 关联订单表 */
    public function shipinfo()
    {
        return $this->hasOne(Ship::class, 'order_list_id', 'id')->withDefault();
    }
}
