<?php

namespace App\Models\Shop;

use App\Models\BaseModel;
use App\Services\Shop\CatModel;
use Illuminate\Database\Eloquent\SoftDeletes;

// 商品
class Change extends BaseModel
{
    use SoftDeletes;

    protected $table = "shop_change";

    public $timestamps = true;

    /** 缩略图修改器 */
    public function setThumbAttribute($value)
    {
        if ($value) {
            $value = implode(',', $value);
        }
        $this->attributes['thumb'] = imageUrl($value, false);
    }
    /** 缩略图访问器 */
    public function getThumbAttribute($value)
    {
        if ($value) {
            $value = explode(',', $value);
        }
        return imageUrl($value);
    }

    /** 富文本修改器 */
    public function setEditorAttribute($value)
    {
        if ($value) {
            $data = getSrc($value);
            if ($data) {
                foreach ($data as $v) {
                    $value = str_ireplace($v, imageUrl($v, false), $value);
                }
            }
        }
        $this->attributes['editor'] = $value;
    }
    public function getEditorAttribute($value)
    {
        if ($value) {
            $data = getSrc($value);
            if ($data) {
                foreach ($data as $v) {
                    $value = str_ireplace($v, imageUrl($v), $value);
                }
            }
        }
        return $value;
    }

    public function catinfo()
    {
        return $this->belongsTo(CatModel::class, 'cat_id', 'id')->withDefault();
    }
}
