<?php

namespace App\Models\User;

use App\Models\BaseModel;

// 提现记录
class Withdraw extends BaseModel
{
    protected $table = 'users_withdraw';

    public $timestamps = true;

    /** 图像修改器 */
    public function setQrcodeAttribute($value)
    {
        $this->attributes['qrcode'] = imageUrl($value, false);
    }
    /** 图像访问器 */
    public function getQrcodeAttribute($value)
    {
        return imageUrl($value);
    }

    /** 关联用户 */
    public function userinfo()
    {
        return $this->hasOne(Users::class, 'id', 'user_id');
    }
}
