<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

/** 验证金额 */
class NumericRule implements Rule
{
    /** 错误消息 */
    public $msg;

    /** 名称 */
    public $name;

    /** 范围 */
    public $range;

    /**
     * 初始化
     *
     * @param  string  $name    名称
     * @param  boolean $range   0全部，1大于0，2大于等于0，3小于0，4小于等于0
     */
    public function __construct($name = '金额', $range = 1)
    {
        $this->name = $name;
        $this->range = $range;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        // 判断数字
        if (!is_numeric($value)) {
            $this->msg = '填写不正确';
            return false;
        }
        // 范围判断
        if ($this->range == 1 && $value <= 0) {
            $this->msg = '要大于0';
            return false;
        }
        if ($this->range == 2 && $value < 0) {
            $this->msg = '不能小于0';
            return false;
        }
        if ($this->range == 3 && $value >= 0) {
            $this->msg = '要小于0';
            return false;
        }
        if ($this->range == 4 && $value > 0) {
            $this->msg = '不能大于0';
            return false;
        }
        // 验证位数
        $rule = "/^[0-9]+(.[0-9]{1,2})?$/";
        if (!preg_match($rule, $value)) {
            $this->msg = '为两位小数';
            return false;
        }
        return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return $this->name . $this->msg;
    }
}
