<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

// 路径验证
class UrlRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (is_string($value)) {
            // 字符串
            $new_data = json_decode($value, true);
            if (!$new_data || !is_array($new_data) || empty($new_data)) {
                $new_data = explode(',', $value);
            }
        } else {
            // 数组
            $new_data = $value;
        }
        // 验证路径
        foreach ($new_data as $v) {
            if (!existsFile($v)) {
                return false;
            }
        }
        return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return '链接不正确';
    }
}
