<?php

namespace App\Services\Box;

use App\Models\Box\Award;
use App\Common\Method\Response;
use App\Services\Order\OrderListModel;
use App\Services\User\UsersModel;

/** 拆盒机奖品 */
class AwardModel extends Award
{
    /**
     * 抽奖
     *
     * @param  object $order
     * @param  object $box
     */
    public function lottery($order, $box)
    {
        // 奖品数据
        $orderListModel = new OrderListModel();
        $userModel = new UsersModel();
        $user = $userModel->where('id',$order->user_id)->first();
        // 开奖次数
        $times = $order->data['num'];
        if ($times <= 0) {
            return Response::error('开奖次数少于一次!');
        }
        // 奖池剩余发数（剩余不够发数重置,重置后不够直接退出）
        $awardList = $this->where(['box_id' => $box->id])->get();
        if (sumData($awardList->toArray(), 'num') < $times) {
            $awardList = $this->reset($box->id);
            if (sumData($awardList->toArray(), 'num') < $times) {
                return Response::error('赏品不足!');
            }
        }
        // 开奖
        if (!$awardList->isEmpty()) {
            // 比例数组
            $rate_list = array_column($awardList->toArray(), 'real_rate', 'id');
            if($user->level == 1){
                //为1更改概率数组为主播概率
                $rate_list = array_column($awardList->toArray(), 'anchor_rate', 'id');
            }
            // 获取奖品数据
            $column = [];
            foreach ($awardList as $v) {
                $column[$v->id] = $v;
            }
            // 抽奖
            for ($i = 1; $i <= $times; $i++) {
                // 获取中奖ID
                $winning_id = luckDraw($rate_list, 1);
                // 数组减少
                $rate_list[$winning_id] -= 1;
                // 抽奖入库
                $award = $column[$winning_id];
                $result = $orderListModel->boxList($order, $box, $award, $orderListModel::G_TYPE_1);
                if (!$result) {
                    return Response::error('开奖失败!');
                }
            }
        }
        return Response::success($result);
    }

    /**
     * 重置奖品数量
     *
     * @param  string $box_id
     */
    public function reset($box_id)
    {
        $list = $this->where(['box_id' => $box_id])->get();
        if (!$list->isEmpty()) {
            foreach ($list as $v) {
                $v->num = $v->real_rate * 100;
                $v->save();
            }
        }
        return $list;
    }
}
