<?php

namespace App\Services\Luckbox;

use App\Models\Luckbox\Award;

/** 拆盒机奖品 */
class AwardModel extends Award
{
    /** 实物奖品 */
    const TYPE_1 = 1;
    /** 现金奖品 */
    const TYPE_2 = 2;
    /** 购物金奖品 */
    const TYPE_3 = 3;
    /** 奖品类型 */
    static public $type = [
        self::TYPE_1 => '实物奖品',
        self::TYPE_2 => '现金奖品',
        self::TYPE_3 => '购物金奖品',
    ];

    /** 普通奖品 */
    const LEVEL_1 = 1;
    /** 隐藏奖品 */
    const LEVEL_2 = 2;
    /** 奖品等级 */
    static public $level = [
        self::LEVEL_1 => '普通奖品',
        self::LEVEL_2 => '隐藏奖品',
    ];

    /** 公共条件 */
    public function factor()
    {
        return $this->where(['status' => 1]);
    }
}
