<?php

namespace App\Services\Order;

use App\Models\Order\Ship;
use App\Common\Method\Response;

class ShipModel extends Ship
{
    /**
     * 发货取消支付
     *
     * @param  object $order
     */
    public static function cancelPay($order)
    {
        // 商品状态改变
        $orderListModel = new OrderListModel();
        $data = $orderListModel->where('id', $order->data['order_list_id'])->first();
        if ($data) {
            $data->status = $orderListModel::STA_0;
            if (!$data->save()) {
                return Response::error('商品状态改变失败!');
            }
        }
        return Response::success();
    }

    /**
     * 发货支付回调
     *
     * @param  object $order
     * @param  object $user
     */
    public static function notify($order, $user)
    {
        $orderListModel = new OrderListModel();
        $data = $orderListModel->where('id', $order->data['order_list_id'])->first();
        if ($data) {
            // 发货信息填入
            $log = new self();
            $log->order_list_id = $order->data['order_list_id'];
            $log->express_money = $order->data['express_money'];
            $log->name = $order->data['name'];
            $log->mobile = $order->data['mobile'];
            $log->address = $order->data['address'];
            $log->ramk = $order->data['ramk'];
            if (!$log->save()) {
                return Response::error('发货信息录入失败!');
            }
            // 置换商品发货信息填入
            if ($order->data['type'] == 2) {
                // 添加置换记录
                $changeModel = new ChangeModel();
                $change = $changeModel;
                $change->order_list_id = $order->data['order_list_id'];
                $change->order_id = $order->id;
                $change->change_id = $order->data['change_id'];
                $change->title = $data->title;
                $change->thumb = $data->thumb;
                $change->price = $data->price;
                // 修改置换状态
                $data->is_change = 1;
                $data->title = $order->data['change_title'];
                $data->thumb = $order->data['change_thumb'];
                $data->price = $order->data['change_price'];
                if (!$change->save() || !$data->save()) {
                    return Response::error('商品状态改变失败!');
                }
            }
        }
        return Response::success();
    }
}
