<?php

namespace App\Services\User;

use Exception;
use App\Models\User\Address;
use App\Common\Method\Response;
use Illuminate\Support\Facades\DB;

/** 收货地址 */
class AddressModel extends Address
{
    /** 默认 */
    const STA_1 = 1;
    /** 不默认 */
    const STA_2 = 2;
    /** 状态 */
    static public $status = [
        self::STA_1 => '默认',
        self::STA_2 => '不默认',
    ];

    /**
     * 地址列表
     *
     * @param  object $user   用户数据
     * @return array
     */
    public function list($user)
    {
        $list = $this->where('user_id', $user->id)
            ->orderBy('status', 'asc')
            ->orderBy('id', 'desc')
            ->select('id', 'name', 'mobile', 'province', 'city', 'area', 'site', 'address', 'status')
            ->get();
        return $list;
    }

    /**
     * 添加/编辑用户地址
     *
     * @param object $user
     * @param object $request
     * @return bool
     */
    public function store($user, $request)
    {
        DB::beginTransaction();
        try {
            //如果是设置默认，就把数据库原有的默认地址状态修改
            if ($request->status == 1) {
                $this->where(['user_id' => $user->id, 'status' => 1])->update(['status' => 2]);
            }
            if ($request->id) {
                $add = $this->where('id', $request->id)->firstOrFail();
            } else {
                $add = $this;
            }
            // 添加
            $add->user_id   = $user->id;                                                                // 用户ID
            $add->name      = $request->name;                                                           // 姓名
            $add->mobile    = $request->mobile;                                                         // 手机号
            $add->province  = $request->province;                                                       // 省
            $add->city      = $request->city ?: '';                                                     // 市
            $add->area      = $request->area;                                                           // 区
            $add->site      = $request->site;                                                           // 详细地址
            $add->address   = $add->province . $add->city . $add->area . $add->site . $add->house_num;  // 全部地址
            $add->status    = $request->status;                                                         // 默认
            $add->save();
            DB::commit();
            return Response::success();
        } catch (Exception $e) {
            DB::rollBack();
            return Response::error('添加失败!');
        }
    }

    /**
     * 设置用户地址默认
     *
     * @param Obj $user
     * @param int $id
     * @return bool
     */
    public function default($user, $id)
    {
        DB::beginTransaction();
        try {
            // 先全部设置不默认
            $this::where('user_id', $user->id)->update(['status' => 2]);
            // 后设置指定ID默认
            $add = $this->where(['id' => $id, 'user_id' => $user->id])->first();
            if (!$add) {
                DB::rollBack();
                return Response::error('地址参数错误!');
            }
            $add->status = 1;
            $add->save();
            DB::commit();
            return Response::success();
        } catch (\Illuminate\Database\QueryException $e) {
            DB::rollBack();
            return Response::error('设置失败!');
        }
    }

    /**
     * 设置用户地址默认
     *
     * @param Obj $user
     * @param int $id
     * @return bool
     */
    public function del($user, $id)
    {
        $add = $this->where(['id' => $id, 'user_id' => $user->id])->first();
        if ($add) {
            $add->delete();
            return Response::success();
        }
        return Response::error('删除失败!');
    }
}
