<?php

namespace App\Services\User;

use App\Models\User\CoinLog;
use App\Common\Method\Response;

/** 积分日志 */
class CoinLogModel extends CoinLog
{
    /** 积分现金比例 */
    public $rate = 10;

    /** 后台添加 */
    const TYPE_1 = 1;
    /** 后台扣除 */
    const TYPE_2 = 2;
    /** 幸运盲盒兑换扣除 */
    const TYPE_3 = 3;
    /** 幸运盲盒签到 */
    const TYPE_4 = 4;
    /** 邀请用户选盒 */
    const TYPE_5 = 5;
    /** 邀请好友开盒 */
    const TYPE_6 = 6;
    /** 开红包 */
    const TYPE_7 = 7;
    /** 积分类型 */
    public static $type = [
        self::TYPE_1 => '后台添加',
        self::TYPE_2 => '后台扣除',
        self::TYPE_3 => '幸运盲盒兑换',
        self::TYPE_4 => '幸运盲盒签到',
        self::TYPE_5 => '邀请用户选盒',
        self::TYPE_6 => '邀请好友开盒',
        self::TYPE_7 => '开红包',
    ];

    /**
     * 积分日志记录添加
     *
     * @param  object $userinfo
     * @param  string $coin
     * @param  string $type
     * @param  string $remark
     */
    public function log($userinfo, $coin, $type, $remark = '', $data_id = null)
    {
        // 改变金额
        $change = formatPrice($coin);
        if (abs($change) < 0.01) {
            return Response::error('金额不正确!');
        }
        $before = $userinfo->coin;              //改变之前的金额
        $after  = calc($before, '+', $change);  //改变之后的金额
        // 余额判断
        if ($after < 0) {
            return Response::error('余额不足!');
        }
        if ($coin > 0) {
            $change = '+' . ltrim($change, '+');
        } else {
            $change = '-' . ltrim($change, '-');
        }
        // 添加记录
        $log = new self();
        $log->user_id = $userinfo->user_id;
        $log->before = $before;
        $log->change  = $change;
        $log->after = $after;
        $log->type = $type;
        $log->desc = self::$type[$type];
        $log->remark = $remark;
        $logResult = $log->save();
        // 用户金额修改
        $userinfo->coin = $after;
        $result = $userinfo->save();
        if (!$logResult || !$result) {
            return Response::error('记录写入失败!');
        }
        return Response::success();
    }

    /**
     * 积分抵扣
     *
     * @param  string $total_money  支付总金额（需支付金额）
     * @param  string $pay_money    剩余需要支付金额
     * @param  object $userinfo     用户详细信息
     */
    public function discount($total_money, $pay_money, $userinfo)
    {
        // 使用折扣(最少0.01元)
        $discount_rate = 10;                                            // 抵扣比例
        $data['total_coin'] = formatPrice($userinfo->coin);             // 剩余总积分数量
        $total_discount = calc($data['total_coin'], '/', $this->rate);  // 剩余抵扣金额
        $data['total_discount'] = $total_discount;
        $data['discount_coin'] = formatPrice(0);                        // 抵扣积分数量
        $data['discount'] = formatPrice(0);                             // 抵扣金额
        $data['pay_money'] = formatPrice($pay_money);                   // 抵扣完需要支付金额
        // 剩余抵扣金额（最少为0.01）
        if ($total_discount > 0.01) {
            // 可抵扣金额（最少为0.01）
            $discount = calc($total_money * $discount_rate, '/', 100);
            if ($discount >= 0.01) {
                if ($pay_money <= $discount) {
                    // 支付价格小于等于可抵扣金额
                    if ($pay_money <= $total_discount) {
                        // 剩余金额充足（抵扣价格=支付价格，直接购买）
                        $discount = $pay_money;
                        $pay_money = formatPrice(0);
                    } else {
                        // 剩余金额不足（抵扣价格=剩余抵扣金额（剩多少低扣多少），还有一部分需要支付）
                        $discount = $total_discount;
                        $pay_money = calc($pay_money, '-', $total_discount);
                    }
                } else {
                    // 支付价格大于抵扣价（不完全抵扣）
                    if ($discount <= $total_discount) {
                        // 抵扣价格小于等于剩余可抵扣价格（抵扣价格=可抵扣价格（能抵扣多少抵扣多少），还有一部分需要支付）
                        $pay_money = calc($pay_money, '-', $discount);
                    } else {
                        // 抵扣价格大于剩余可抵扣价格（抵扣价格=剩余抵扣金额（剩多少低扣多少），还有一部分需要支付）
                        $discount = $total_discount;
                        $pay_money = calc($pay_money, '-', $total_discount);
                    }
                }
                $data['discount_coin'] = calc($discount, '*', $discount_rate);
                $data['discount'] = formatPrice($discount);
                $data['pay_money'] = formatPrice($pay_money);
            }
        }
        return $data;
    }
}
