<?php

namespace App\Services\User;

use App\Models\User\Daili;
use App\Common\Method\Response;
use App\Services\User\MoneyLogModel;
use App\Services\User\UsersModel;
use Illuminate\Support\Facades\DB;
/** 充值记录表 */
class DailiModel extends Daili
{
    /** 待审核 */
    const STA_0 = 0;
    /** 审核通过 */
    const STA_1 = 1;
    /** 支付状态 */
    static public $status = [
        self::STA_0 => '待审核',
        self::STA_1 => '审核通过',
    ];
    /**
     * 申请代理
     *
     * @param object $user
     * @param object $request
     * @return bool
     */
    public function store($user, $request)
    {
        
        DB::beginTransaction();
        try {
            $add = $this;
            // 添加
            $add->user_id   = $user->id;                                                                // 用户ID
            $add->name      = $request->name;                                                           // 姓名
            $add->mobile    = $request->mobile;                                                         // 手机号
            $add->superior  = $request->superior ?: '';                                                       // 省
            $add->save();
            DB::commit();
            return Response::success();
        } catch (Exception $e) {
            DB::rollBack();
            return Response::error('添加失败!');
        }
    }
}
