<?php

namespace App\Services\User;

use App\Models\User\Friend;
use App\Common\Method\Response;
use Illuminate\Database\QueryException;


class FriendModel extends Friend
{
    /** 返回值：已存在（同一订单已发放过，用于防并发） */
    const ADD_RESULT_ALREADY_EXISTS = 'already_exists';

    /**
     * 添加记录（同一 order_id 仅允许一条，用于防并发重复发放）
     *
     * @param  object $user
     * @param  object $friend
     * @param  object $box
     * @param  object $order
     * @param  float  $commissionAmount
     * @return mixed true=成功, false=失败, self::ADD_RESULT_ALREADY_EXISTS=已存在跳过
     */
    public function add($user, $friend, $box, $order, $commissionAmount = 0)
    {
        $log = new self();
        $log->user_id = $user->id;
        $log->friend_id = $friend->id;
        $log->order_id = $order->id;
        $log->box_id = $box->id;
        $log->title = $box->title;
        $log->thumb = $box->thumb;
        $log->get_money = $commissionAmount;
        $log->get_coin = calc($box->send_coin, '*', $order->data['num'], 0);
        try {
            if (!$log->save()) {
                return false;
            }
            return true;
        } catch (QueryException $e) {
            // 唯一约束冲突（同一订单已发放过）
            if ($e->getCode() === '23000' || strpos($e->getMessage(), 'Duplicate entry') !== false) {
                return self::ADD_RESULT_ALREADY_EXISTS;
            }
            return false;
        }
    }
}
