<?php

namespace App\Services\User;

use App\Models\Recharge\RechargeLog;
use App\Common\Method\Response;
use App\Services\User\MoneyLogModel;
use App\Services\User\UsersModel;
/** 充值记录表 */
class RechargeLogModel extends RechargeLog
{
        /** 支付失败 */
    const STA_MIN_1 = -1;
    /** 待支付 */
    const STA_0 = 0;
    /** 已完成 */
    const STA_1 = 1;
    /** 支付状态 */
    static public $status = [
        self::STA_MIN_1 => '支付失败',
        self::STA_0 => '待支付',
        self::STA_1 => '已完成',
    ];
        /**
     * 支付
     *
     * @param  object $user     用户数据
     * @param  string $type     订单类型
     * @param  array  $param    数据[
     *          pay_type        支付方式       必填
     *          gold            是否购物金抵扣 必填
     *          money          是否余额抵扣    必填
     * @param  array  $discount[
     *          total_money     支付金额
     *          pay_money       支付金额
     *          gold_dis        购物金抵扣金额
     *          money_dis       余额抵扣金额
     * ]
     * @param  object $request  请求
     * @param  array  $data     其他数据
     */
    public function pay($user,$money,$getMoney)
    {
        $order = new self();
        $order->out_trade_no = $this->out_trade_no();
        $order->user_id = $user->id;
        $order->pay_money = $money;
        $order->get_money = $getMoney;
        if (!$order->save()) {
            return Response::error('订单生成失败!');
        }
        return Response::success($order);
    }
    /**
     * 生成订单号
     */
    public function out_trade_no()
    {
        $out_trade_no = orderNum();
        $coupon = $this->where(['out_trade_no' => $out_trade_no])->first();
        if ($coupon) {
            return $this->out_trade_no;
        }
        return $out_trade_no;
    }
    
        /**
     * 回调
     *
     * @param  object $order
     */
    public function notify($order)
    {
        // 公共部分
        //修改订单状态
        $usersModel = new UsersModel();
        $moneyLogModel  = new MoneyLogModel();
        $user = $usersModel->where('id', $order->user_id)->first();
        if ($order->status != self::STA_0) {
            return Response::error('订单状态不正确!');
        }
        $order->status = self::STA_1;
        $order->pay_time = time();
        if (!$order->save()) {
            return Response::error('订单状态修改失败!');
        }
        if ($user) {
            $moneyLogModel->log($user->userinfo,$order->get_money,$moneyLogModel::TYPE_12);
        }
        return Response::success();
    }
}
