<?php

namespace App\Services\User;

use App\Models\User\Users;
use App\ToolsClass\RedisTool;
use App\Common\Enum\RedisEnum;
use App\Common\Method\Response;

/** 用户 */
class UsersModel extends Users
{
    /** 公共条件 */
    public function factor()
    {
        return $this->where(['status' => 1]);
    }

    /**
     * 用户注册
     *
     * @param  array  $param    参数
     * @param  object $sms      短信数据
     */
    public function register($param)
    {
        $treeModel = new TreeModel();
        
        // 用户主表添加
        $user = new self();
        $user->openid = $param['openid'];
        $user->nickName = $param['nickname'];
        $user->avatar = $param['avatarurl'];
        $user->invite_code = $this->invite_code();
        
        if (!$user->save()) {
            \Log::error('用户主表添加失败');
            return Response::error('用户添加失败!');
        }
        
        // 用户附表 - 使用 firstOrCreate 避免重复插入
        try {
            $userInfo = InfoModel::firstOrCreate(
                ['user_id' => $user->id],  // 查找条件
                []  // 如果不存在则创建，使用默认值
            );
        } catch (\Exception $e) {
            \Log::error('用户附表操作异常: ' . $e->getMessage());
            return Response::error('用户附表添加失败!');
        }
        
        // 关系表
        $treeRes = $treeModel->registerBind($user, $param);
        if (!$treeRes) {
            \Log::error('用户关系添加失败');
            return Response::error('用户关系添加失败!');
        }
        
        return Response::success($user);
    }

    /**
     * Token 返回
     *
     * @param  string $token
     */
    public static function respondWithToken($user, $token)
    {
        $redis = new RedisTool();
        if (env('JWT_SINGLE_SWITCH')) {
            $time = 0;
            if (config('jwt.ttl')) {
                $time = config('jwt.ttl') * 60;
            }
            $redis->set(RedisEnum::API_TOKEN . $user->id, $token, $time);
        }
        return [
            'access_token' => $token,
            'token_type' => 'bearer',
        ];
    }

    /**
     * 生成邀请码
     */
    public function invite_code()
    {
        $invite_code = code();
        $user = $this->where(['invite_code' => $invite_code])->first();
        if ($user) {
            return $this->invite_code;
        }
        return $invite_code;
    }

    /**
     * 生成随机头像
     */
    public function randAvatar()
    {
        return '/uploads/other/avatar' . mt_rand(1, 20) . '.png';
    }
}
