<?php

namespace App\ToolsClass;

use App\Common\Enum\RedisEnum;
use App\Common\Method\Response;
use App\Models\Admin\Configuration;
use App\Services\Order\DeliveryModel;

/** 阿里云快递查询 */
class AliwuliuTool
{
    // HOST
    protected $host = 'https://wuliu.market.alicloudapi.com/kdi';

    // 配置
    protected $config;

    // Redis
    protected $redis;

    // 快递状态
    public $status = [
        0 => '快递收件(揽件)',
        1 => '在途中',
        2 => '正在派件',
        3 => '已签收',
        4 => '派送失败（无法联系到收件人或客户要求择日派送，地址不详或手机号不清）',
        5 => '疑难件（收件人拒绝签收，地址有误或不能送达派送区域，收费等原因无法正常派送）',
        6 => '退件签收',
    ];

    /** 初始化配置 */
    public function __construct()
    {
        $field = ['express_cache_times', 'express_appcode'];
        $this->config = Configuration::getVal($field);
        $this->redis = new RedisTool();
    }

    /**
     * 查询快递
     *
     * @param  string $number
     * @param  string $code
     * @param  string $mobile
     */
    public function search($number, $code, $mobile)
    {
        // Redis 缓存
        $key = RedisEnum::EXPRESS . $number;
        $data = $this->redis->get($key);
        $data = null;
        if ($data) {
            $data = unserialize($data);
            if ($data) {
                return Response::success($data);
            }
        }
        // 从缓存获取
        $data = $this->getInfo($number, $code, $mobile);
        if (!$data) {
            return Response::error(Response::getMessage());
        }
        // 组合返回信息
        $new_data['list'] = $data['list'];
        $express = DeliveryModel::where('code', $code)->first();
        if (!$express) {
            return Response::error('数据库暂无该物流信息');
        }
        $new_data['expName'] = $express->name;
        $new_data['number'] = $number;
        $new_data['deliverystatus_desc'] = $data['deliverystatus_desc'];
        // 设置缓存
        $this->redis->set($key, serialize($new_data), 60 * $this->config['express_cache_times']);
        return Response::success($new_data);
    }

    /**
     * 查询快递
     *
     * @param  string $number
     * @param  string $code
     * @param  string $mobile
     */
    public function getInfo($number, $code, $mobile)
    {
        $method = "GET";
        $headers = array();
        array_push($headers, "Authorization:APPCODE " . $this->config['express_appcode']);
        if ($code == 'SFEXPRESS') {
            // 顺丰特殊化
            $querys = '?no=' . $number . ':' . substr($mobile, -4) . '&type=' . $code;
        } else {
            // 其他快递
            $querys = '?no=' . $number . '&type=' . $code;
        }
        $bodys = "";
        $url = $this->host .  "?" . $querys;
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_FAILONERROR, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HEADER, true);
        if (1 == strpos("$" . $this->host, "https://")) {
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        }
        $out_put = curl_exec($curl);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        list($header, $body) = explode("\r\n\r\n", $out_put, 2);
        if ($httpCode == 200) {
            $data = jsonDecode($body);
            if ($data['status'] == '201') {
                return Response::error("快递单号错误");
            }
            if ($data['status'] == '203') {
                return Response::error("快递公司不存在");
            }
            if ($data['status'] == '204') {
                return Response::error("快递公司识别失败");
            }
            if ($data['status'] == '207') {
                return Response::error("IP限制");
            }
            if ($data['status'] == '205') {
                $data = $data['result'];
                $data['deliverystatus_desc'] = '暂无物流信息';
                return Response::success($data);
            }
            if ($data['status'] == '0') {
                $data = $data['result'];
                $data['deliverystatus_desc'] = $this->status[$data['deliverystatus']];
                return Response::success($data);
            }
            return Response::error("查询失败");
        } else {
            if ($httpCode == 400 && strpos($header, "Invalid Param Location") !== false) {
                return Response::error("参数错误");
            } elseif ($httpCode == 400 && strpos($header, "Invalid AppCode") !== false) {
                return Response::error("AppCode错误");
            } elseif ($httpCode == 400 && strpos($header, "Invalid Url") !== false) {
                return Response::error("请求的 Method、Path 或者环境错误");
            } elseif ($httpCode == 403 && strpos($header, "Unauthorized") !== false) {
                return Response::error("服务未被授权（或URL和Path不正确）");
            } elseif ($httpCode == 403 && strpos($header, "Quota Exhausted") !== false) {
                return Response::error("套餐包次数用完");
            } elseif ($httpCode == 403 && strpos($header, "Api Market Subscription quota exhausted") !== false) {
                return Response::error("套餐包次数用完，请续购套餐");
            } elseif ($httpCode == 500) {
                return Response::error("API网关错误");
            } elseif ($httpCode == 0) {
                return Response::error("URL错误");
            } else {
                return Response::error("参数名错误 或 其他错误");
            }
        }
    }
}
