<?php

namespace App\ToolsClass;

use App\Models\Admin\Configuration;
use Illuminate\Support\Facades\Storage;

/** 图片处理 */
class PicTool
{
    /** 上传驱动 */
    protected static $disk = 'api';

    /** 设置上传驱动 */
    public static function disk($disk)
    {
        self::$disk = $disk;
        return new self;
    }

    /**
     * 下载远程/本地图片
     *
     * @param string $url   远程图片地址
     * @param string $dir   文件目录例子：local/avatar
     * @param string $name  文件名
     * @return string
     */
    public static function curlPic($url, $dir = '', $name = '')
    {
        $suffix = self::getSuffix($url);
        $data = file_get_contents($url);
        return self::put($data, $dir, $name, $suffix);
    }

    /**
     * 把Base64数据转换成图片
     *
     * @param string $data  二进制流数据
     * @param string $dir   文件目录例子：local/avatar
     * @param string $name  文件名
     * @return string
     */
    public static function base64Pic($data, $dir = '', $name = '')
    {
        $suffix = self::getSuffix($data);
        // 获取Base64 数据
        $data = explode(',', $data)[1];  //截取data:image/png;base64, 这个逗号后的字符\
        // 转成二进制流数据写入文件
        $data = base64_decode($data);
        return self::put($data, $dir, $name, $suffix);
    }

    /**
     * 通过二进制内容获取Base64 数据
     *
     * @param string $content
     * @return string
     */
    public static function base64($content)
    {
        $type = getimagesizefromstring($content)['mime']; //获取二进制流图片格式
        $base64String = 'data:' . $type . ';base64,' . chunk_split(base64_encode($content));
        return $base64String;
    }

    /**
     * 平均分割图片|| 生成缩率图 X 轴分割
     *
     * @param string $path      要分割的图片路径
     * @param string $dir       分割后存的目录
     * @param string $suffix    分割后的后缀
     * @param integer $p        分割的次数
     * @return void
     */
    public static function getPicX($path, $dir, $p = 1)
    {
        //判断类型
        $type = getimagesize($path)[2];
        if (!in_array($type, [1, 2, 3])) {
            return false;
        }
        //没有文件夹创建
        $save_dir = '.' . $dir;
        !file_exists($save_dir) && mkdir($save_dir, 0777, true);
        //获取尺寸
        list($width, $height) = getimagesize($path);
        $newwidth = floor($width / $p);
        $newheight = $height;
        //剩余的尺寸
        $last = $width % $p;
        // Load
        if ($type == 1) {
            header("Content-type: image/gif");
            $source = ImageCreateFromGIF($path);
            $suffix = '.gif';
            $function = 'imagegif';
        } elseif ($type == 2) {
            $source = ImageCreateFromJPEG($path);
            $suffix = '.jpg';
            $function = 'imagejpeg';
        } elseif ($type == 3) {
            $source = ImageCreateFromPNG($path);
            $suffix = '.png';
            $function = 'imagepng';
        }
        for ($i = 0; $i < $p; $i++) {
            $_p = $newwidth * $i;
            if (($i + 1) == $p)
                $newwidth += $last;
            $thumb = ImageCreateTrueColor($newwidth, $newheight); //创建画布
            imagecopyresized($thumb, $source, 0, 0, $_p, 0, $width,  $height, $width, $height); //生成图片
            $function($thumb, $save_dir . $i . $suffix, 100);
            $afterPicArr[$i] = $dir . $i . $suffix;
        }
        return $afterPicArr;
    }

    /**
     * 文件上传
     *
     * @param string $data      二进制流数据
     * @param string $path      路径
     * @param string $name      文件名称 要带
     * @param string $suffix    后缀
     * @return string
     */
    public static function put($data, $path, $name, $suffix)
    {
        // 获取保存路径
        if ($path) {
            $path = '/' . trim($path, '/') . '/' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        } else {
            $path .=  '/' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        }
        // 获取名称
        if (!$name) {
            $name = md5(time());
        }
        // 获取文件名（含后缀）
        $type = Configuration::getVal('storage_type');
        $path =  $type . $path;
        $path  = $path . $name . $suffix;
        // 上传
        Storage::disk(self::$disk)->put($path, $data);
        // 返回路径
        return Storage::disk(self::$disk)->url($path);
    }

    /**
     * 获取文件后缀
     *
     * @param  string $file
     */
    private static function getSuffix($file)
    {
        $info = getimagesize($file);
        $mime = $info['mime'];
        $suffix = '.' . explode('/', $mime)[1];
        return $suffix;
    }
}
