<?php

namespace App\ToolsClass;

/** 时间处理 */
class TimeTool
{
    /**
     * 获取N分钟前-现在时间戳
     *
     * @param  integer $minute
     */
    public static function minute($minute)
    {
        $time = time();
        $start_time = $time - 60 * $minute;
        $end_time = $time;
        return [$start_time, $end_time];
    }

    /**
     * 获取最近 N 小时的时间
     *
     * @param integer $num
     * @param string $time
     * @param string $format
     * @param string $formats
     * @return array
     */
    public static function hours($num = 6, $format = 'Y-m-d H:00:00', $formats = 'H')
    {
        $time = time();
        //组合数据
        $date = [];
        for ($i = 1; $i <= $num; $i++) {
            $arr['date'] = [date($format, strtotime('+' . ($i - $num) . ' hours', $time)), date($format, strtotime('+' . (($i - $num + 1)) . ' hours', $time))];
            $arr['dates'] = date($formats, strtotime('+' . ($i - $num + 1) . ' hours', $time));
            $date[] = $arr;
        }
        return $date;
    }

    /**
     * 获取当天开始-现在时间戳（查询今日数据用）
     */
    public static function day()
    {
        $start_time = mktime(0, 0, 0, date('m'), date('d'), date('y'));
        $end_time = time();
        return [$start_time, $end_time];
    }

    /**
     * 获取昨天开始-结束时间戳（查询你昨日数据用）
     */
    public static function yesterday()
    {
        $start_time = mktime(0, 0, 0, date('m'), date('d') - 1, date('y'));
        $end_time = mktime(0, 0, 0, date('m'), date('d'), date('y')) - 1;
        return [$start_time, $end_time];
    }

    /**
     * 获取本周开始-现在时间戳（查询本周数据用）
     * 
     * @return array
     */
    public static function week()
    {
        $start_time =  mktime(0, 0, 0, date('m'), date('d') - date('w') + 1, date('y'));
        $end_time = time();
        return [$start_time, $end_time];
    }

    /**
     * 查询上周数据
     * 
     * @return array
     */
    public static function lastWeek()
    {
        $start_time =  mktime(0, 0, 0, date('m'), date('d') - date('w') - 6, date('y'));
        $end_time = mktime(23, 59, 59, date('m'), date('d') - date('w'), date('y'));
        return [$start_time, $end_time];
    }

    /**
     * 查询本月数据
     * 
     *  @return array
     */
    public static function month()
    {
        $start_time =  mktime(0, 0, 0, date('m'), 1, date('y'));
        $end_time = time();
        return [$start_time, $end_time];
    }

    /**
     * 查询上月数据
     * 
     * @return array
     */
    public static function lastMonth()
    {
        $m = date('Y-m-d', mktime(0, 0, 0, date('m') - 1, 1, date('Y')));
        $t = date('t', strtotime($m)); //上个月共多少天
        $start_time = mktime(0, 0, 0, date('m') - 1, 1, date('Y'));
        $end_time = mktime(23, 59, 59, date('m') - 1, $t, date('Y'));
        return [$start_time, $end_time];
    }

    /**
     * 查询今年数据
     * 
     * @return array
     */
    public static function year()
    {
        $start_time =  mktime(0, 0, 0, 1, 1, date('y'));
        $end_time = time();
        return [$start_time, $end_time];
    }

    /**
     * 查询去年数据
     * 
     * @return array
     */
    public static function lastYear()
    {
        $start_time =  mktime(0, 0, 0, 1, 1, date('y') - 1);
        $end_time = mktime(0, 0, 0, 1, 1, date('y')) - 1;
        return [$start_time, $end_time];
    }

    /**
     * 查询某个时间(例子：2022年3月-现在)
     *
     * @param  integer $year
     * @param  integer $month
     */
    public static function monthNow($year, $month)
    {
        $start_time =  mktime(0, 0, 0, $month, 1, $year);
        $end_time = time();
        return [$start_time, $end_time];
    }

    /**
     * 查询某个月的时间戳（例子：2022年3月1日-2022年3月31日）
     *
     * @param  integer $year
     * @param  integer $month
     */
    public static function someMonth($year, $month)
    {
        $start_time =  mktime(0, 0, 0, $month, 1, $year);
        $end_time = mktime(0, 0, 0, $month + 1, 1, $year) - 1;
        return [$start_time, $end_time];
    }

    /**
     * 获取最近 N 天日期 （2022-07-01）
     *
     * @param integer $num
     * @param string $format
     * @return
     */
    public static function days($num = 7)
    {
        //组合数据
        $date = [];
        for ($i = 1; $i <= $num; $i++) {
            $date[$i] = date('Y-m-d', strtotime('+' . $i - $num . ' days', time()));
        }
        return array_values($date);
    }

    /**
     * 获取当天时间段
     *
     * @param  string  $date    日期：null 表示当前，2022-11-13 最少指定为某天日期
     * @param  boolean $type    类型：true 当天全部时间，false 截止到当前
     * @return array   [
     *      date array       时间区间
     *      time string      时间
     * ]
     */
    public static function dayHours($date = null, $type = false)
    {
        $timestamp = mktime(0, 0, 0, date("m"), date("d"), date("y"));
        if ($date) {
            $time = date('Y-m-d', strtotime($date));
            $timestamp = strtotime($time);
        }
        //组合数据
        $data = [];
        $time = date('H', time()) + 1;
        if ($type) {
            $time = 24;
        }
        for ($i = 0; $i < 24; $i++) {
            $b = $timestamp + ($i * 3600);
            $e = $timestamp + (($i + 1) * 3600);
            if ($i < $time) {
                $data[$i]['date'] = [date("Y-m-d H:i:s", $b), date("Y-m-d H:i:s", $e)];
                $data[$i]['time'] = date("H:i", $e);
                //截止到现在
                if (date("H:i", $e) == '00:00') {
                    $data[$i]['time'] = '24:00';
                }
            }
        }
        return $data;
    }

    /**
     * 获取某周所有日期
     *
     * @param string $date  日期：null 表示当前，2022-11-13 最少指定为某天日期
     * @param string $type  全部，false截至到昨天
     * @return array
     */
    public static function weekDays($date = '', $type = false)
    {
        $timestamp = $date != '' ? strtotime($date) : time();
        //获取当前周几
        $week = date('w', $timestamp);
        // 今天日期
        $times = date('Y-m-d', $timestamp);
        $data = [];
        for ($i = 1; $i <= 7; $i++) {
            $day = date('Y-m-d', strtotime('+' . $i - $week . ' days', $timestamp));
            $dayTimestamp = strtotime($day);
            $a = date('Y-m-d H:i:s', $dayTimestamp);
            $b = date('Y-m-d H:i:s', strtotime('+' . ' 1days', $dayTimestamp - 1));
            $data[$i]['date'] = [$a, $b];
            $data[$i]['time'] = $day;
            //截止到当天
            if ((!$date && !$type && $times == $data[$i]['time'])) {
                break;
            }
        }
        return array_values($data);
    }

    /**
     * 获取某月所有日期
     *
     * @param string $date  日期：null 表示当前，2022-11-13 最少指定为某天日期
     * @param string $type  true 全部，false截至到昨天
     * @return array
     */
    public static function monthDays($date = '', $type = false)
    {
        $timestamp = $date != '' ? strtotime($date) : time();
        //获取本月几天
        $num = date('t', $timestamp);
        $start_time = strtotime(date('Y-m-01', $timestamp));  //获取本月第一天时间戳
        $times = date('Y-m-d', $timestamp);
        if ($type) {
            $times = date('Y-m-d', strtotime(date('Y-m-01', $start_time) . ' +1 month -1 day'));
        }
        $data = [];
        for ($i = 0; $i < $num; $i++) {
            $day = date('Y-m-d', $start_time + $i * 86400);
            $dayTimestamp = strtotime($day);
            $a = date('Y-m-d H:i:s', $dayTimestamp);
            $b = date('Y-m-d H:i:s', strtotime('+' . ' 1days', $dayTimestamp - 1));
            $data[$i]['date'] = [$a, $b];
            $data[$i]['time'] = date('Y-m-d', $start_time + $i * 86400);
            //截止到当天
            if ((!$date && !$type && $times == $data[$i]['time'])) {
                break;
            }
        }
        return $data;
    }

    /**
     * 时间距现在天/时/分/秒
     *
     * @param int $time
     * @return string
     */
    public static function timetoString($time)
    {
        $time = time() - $time;
        $day = floor($time / (3600 * 24));
        $day = $day ? $day : '';

        $time = $time % (3600 * 24); //除去整天之后剩余的时间
        $hour = floor($time / 3600);
        $hour = $hour ? $hour  : '';

        $time = $time % 3600; //除去整小时之后剩余的时间 
        $minute = floor($time / 60);
        $minute = $minute ? $minute  : '';

        $time = $time % 60; //除去整分钟之后剩余的时间 
        $time = $time ? $time  : '';
        //返回字符串
        if ($day) {
            return $day . '天前';
        }
        if ($hour) {
            return $hour . '小时前';
        }
        if ($minute) {
            return $minute . '分钟前';
        }
        if ($time) {
            return $time . '秒前';
        }
    }

    /**
     * 根据出生年月获取一个人的年龄
     * 
     * @param $birthday 出生年月日（1992-1-3）
     * @return string 年龄
     */
    public static function age($birthday)
    {
        $year = date('Y');
        $month = date('m');
        if (substr($month, 0, 1) == 0) {
            $month = substr($month, 1);
        }
        $day = date('d');
        if (substr($day, 0, 1) == 0) {
            $day = substr($day, 1);
        }
        $arr = explode('-', $birthday);

        $age = $year - $arr[0];
        if ($month < $arr[1]) {
            $age = $age - 1;
        } elseif ($month == $arr[1] && $day < $arr[2]) {
            $age = $age - 1;
        }

        return $age;
    }
}
