<?php

namespace App\ToolsClass;

use App\Common\Method\Response;
use App\Models\Admin\Configuration;
use Illuminate\Support\Facades\Storage;

/** 文件上传 */
class UploadTool
{
    // 配置实列
    protected $model;

    // 上传驱动
    protected $disk = 'uploads';

    /**
     * 设置驱动
     *
     * @param  [type] $disk
     */
    public function disk($disk)
    {
        $this->disk = $disk;
        return $this;
    }

    /**
     * 下载远程/本地图片
     *
     * @param string $url   远程图片地址
     * @param string $dir   文件目录例子
     * @param string $name  文件名
     * @return string
     */
    public function curlPic($url, $dir, $name = '')
    {
        // 获取后缀
        $info = getimagesize($url);
        $mime = $info['mime'];
        $suffix = explode('/', $mime)[1];
        // 获取二进制流数据
        $data = file_get_contents($url);
        $res = self::put($data, $dir, $name, $suffix);
        if (!$res) {
            return Response::error(Response::getMessage());
        }
        return Response::success($res);
    }

    /**
     * 把Base64数据转换成图片
     *
     * @param string $data  base64 数据
     * @param string $dir   文件目录例子
     * @param string $name  文件名
     * @return string
     */
    public function base64Pic($data, $dir, $name = '')
    {
        // 获取后缀
        $info = getimagesize($data);
        $mime = $info['mime'];
        $suffix = explode('/', $mime)[1];
        // 获取Base64 数据
        $data = explode(',', $data)[1];  //截取data:image/png;base64, 这个逗号后的字符\
        // 转成二进制流数据写入文件
        $data = base64_decode($data);
        $res = self::put($data, $dir, $name, $suffix);
        if (!$res) {
            return Response::error(Response::getMessage());
        }
        return Response::success($res);
    }

    /**
     * 通过二进制内容获取Base64 数据
     *
     * @param string $content
     * @return string
     */
    public function base64($content)
    {
        $type = getimagesizefromstring($content)['mime']; //获取二进制流图片格式
        $base64String = 'data:' . $type . ';base64,' . chunk_split(base64_encode($content));
        return $base64String;
    }

    /**
     * 平均分割图片|| 生成缩率图 X 轴分割
     *
     * @param string $path      要分割的图片路径
     * @param string $dir       分割后存的目录
     * @param string $suffix    分割后的后缀
     * @param integer $p        分割的次数
     * @return
     */
    public function getPicX($path, $dir, $p = 1)
    {
        //判断类型
        $type = getimagesize($path)[2];
        if (!in_array($type, [1, 2, 3])) {
            return false;
        }
        //没有文件夹创建
        $save_dir = '.' . $dir;
        !file_exists($save_dir) && mkdir($save_dir, 0777, true);
        //获取尺寸
        list($width, $height) = getimagesize($path);
        $newwidth = floor($width / $p);
        $newheight = $height;
        //剩余的尺寸
        $last = $width % $p;
        // Load
        if ($type == 1) {
            header("Content-type: image/gif");
            $source = ImageCreateFromGIF($path);
            $suffix = '.gif';
            $function = 'imagegif';
        } elseif ($type == 2) {
            $source = ImageCreateFromJPEG($path);
            $suffix = '.jpg';
            $function = 'imagejpeg';
        } elseif ($type == 3) {
            $source = ImageCreateFromPNG($path);
            $suffix = '.png';
            $function = 'imagepng';
        }
        for ($i = 0; $i < $p; $i++) {
            $_p = $newwidth * $i;
            if (($i + 1) == $p)
                $newwidth += $last;
            $thumb = ImageCreateTrueColor($newwidth, $newheight); //创建画布
            imagecopyresized($thumb, $source, 0, 0, $_p, 0, $width,  $height, $width, $height); //生成图片
            $function($thumb, $save_dir . $i . $suffix, 100);
            $afterPicArr[$i] = $dir . $i . $suffix;
        }
        return $afterPicArr;
    }

    /**
     * 文件上传
     *
     * @param string $data      二进制流数据
     * @param string $dir       路径(文件夹名称)
     * @param string $name      文件名称
     * @param string $suffix    后缀
     * @return string
     */
    public function put($data, $dir, $name, $suffix, $type = 'image')
    {
        // 获取保存路径
        $path = '/' . trim($dir, '/') . '/' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        // 获取名称
        if (!$name) {
            $name = md5(time());
        }
        // 获取文件名（含后缀）
        if ($this->disk == 'aliyun' || $this->disk == 'qiniuyun') {
            $path =  env('DB_DATABASE') . '/' . $this->disk . $path;
        } else {
            $path =  $this->disk . $path;
        }
        $path  = $path . $name . '.' . $suffix;
        // 验证
        $config = new Configuration();
        switch ($type) {
            case 'image':
                $suffix_arr = explode(',', $config->getVal('storage_image_type'));
                if (!in_array($suffix, $suffix_arr)) {
                    return Response::error('不支持' . $suffix . '图片');
                }
                $size = $config->getVal('storage_image_size');
                if ($size * 1024 * 1024 < strlen($data)) {
                    return Response::error('请上传小于' . $size . 'M的图片');
                }
                break;
            case 'audio':
                $suffix_arr = explode(',', $config->getVal('storage_audio_type'));
                if (!in_array($suffix, $suffix_arr)) {
                    return Response::error('不支持' . $suffix . '音频');
                }
                $size = $config->getVal('storage_audio_size');
                if ($size * 1024 * 1024 < strlen($data)) {
                    return Response::error('请上传小于' . $size . 'M的音频');
                }
                break;
            case 'video':
                $suffix_arr = explode(',', $config->getVal('storage_video_type'));
                if (!in_array($suffix, $suffix_arr)) {
                    return Response::error('不支持' . $suffix . '视频');
                }
                $size = $config->getVal('storage_video_size');
                if ($size * 1024 * 1024 < strlen($data)) {
                    return Response::error('请上传小于' . $size . 'M的视频');
                }
                break;
            case 'file':
                $suffix_arr = explode(',', $config->getVal('storage_file_type'));
                if (!in_array($suffix, $suffix_arr)) {
                    return Response::error('不支持' . $suffix . '文件');
                }
                $size = $config->getVal('storage_file_size');
                if ($size * 1024 * 1024 < strlen($data)) {
                    return Response::error('请上传小于' . $size . 'M的文件');
                }
                break;
        }
        // 上传
        Storage::disk($this->disk)->put($path, $data);
        // 返回路径
        $url = Storage::disk($this->disk)->url($path);
        return Response::success($url);
    }

    /**
     * 大文件分片上传
     *
     * @param  object $request  
     * @param  string $dir      文件存放目录
     * @param  string $name     文件名称（不填为随机名称）
     */
    public function sliceUp($request, $dir, $name = '')
    {
        $file = $request->file('file');                     // 文件名称
        $num = $request->get('num');                        // 当前分片数
        $total = $request->get('total');                    // 总分片数量
        $file_name = $request->get('file_name');            // 文件名
        $realPath = $file->getRealPath();                   //临时文件的绝对路径
        // 获取保存路径
        $path = '/' . trim($dir, '/') . '/' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        $path =  $this->disk . $path;
        // 获取名称
        if (!$name) {
            $name = md5(time());
        }
        $filename = $path . '/' . $file_name . '_' . $num;
        //上传
        $upload = Storage::disk($this->disk)->put($filename, file_get_contents($realPath));
        //判断是否是最后一块，如果是则进行文件合成并且删除文件块
        if ($num == $total) {
            for ($i = 1; $i <= $total; $i++) {
                $blob = Storage::disk($this->disk)->get($path . '/' . $file_name . '_' . $i);
                // 获取文件后缀
                $suffix = $file->fileExtension = substr($file_name, strripos($file_name, '.') + 1);
                $filepath = $path . $name . '.' . $suffix;
                // 将文件分块合并成文件
                $result = Storage::disk($this->disk)->append($filepath, $blob, null);
            }
            //合并完删除文件块
            for ($i = 1; $i <= $total; $i++) {
                Storage::disk($this->disk)->delete($path . '/' . $file_name . '_' . $i);
            }
            if ($result) {
                return Response::success(Storage::disk($this->disk)->url($filepath));
            } else {
                return Response::error('上传失败!');
            }
        }
        if ($upload) {
            return Response::success();
        } else {
            return Response::error('上传失败!');
        }
    }
}
