<?php

namespace App\ToolsClass\WeChat;

use Exception;
use EasyWeChat\Factory;
use App\ToolsClass\UploadTool;
use App\Common\Method\Response;
use App\Exceptions\ApiException;
use App\Models\Admin\Configuration;
use Symfony\Component\Cache\Adapter\RedisAdapter;

/** 微信小程序 */
class MiniProgramTool
{
    /** 小程序实例 */
    private $app;

    // 初始化操作
    public function __construct()
    {
        $configModel = new Configuration();
        $config = [
            'app_id' => $configModel->getVal('mini_appid'),    // 微信Appid
            'secret' => $configModel->getVal('mini_secret'),   // 微信密钥
        ];
        $this->app = Factory::miniProgram($config);
        // 创建缓存实例
        $cache = new RedisAdapter(app('redis')->connection()->client());
        $this->app->rebind('cache', $cache);
    }

    /**
     * 获取小程序 AccessToken
     * @return mixed
     * @throws \EasyWeChat\Kernel\Exceptions\HttpException
     * @throws \EasyWeChat\Kernel\Exceptions\InvalidArgumentException
     * @throws \EasyWeChat\Kernel\Exceptions\InvalidConfigException
     * @throws \EasyWeChat\Kernel\Exceptions\RuntimeException
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public function accessToken()
    {
        $accessToken = $this->app->access_token;

        return $accessToken->getToken()['access_token']; // token 数组  token['access_token'] 字符串
    }

    /**
     * 获取用户Openid/Unionid(授权登陆)
     *
     * @param string $code  授权登陆Code
     * @return array [
     *      session_key 会话密钥
     *      openid      用户唯一标识
     *      unionid     用户在开放平台的唯一标识符，若当前小程序已绑定到微信开放平台帐号下会返回
     *  ]
     */
    public function sessionKey($code)
    {
        if (!$code) {
            \Log::error('MiniProgramTool::sessionKey - code为空');
            return Response::error('缺少登录信息!');
        }
        
        try {
            $result = $this->app->auth->session($code);
            
            if (isset($result['errcode'])) {
                $errorMsg = '微信接口错误(' . $result['errcode'] . '): ' . $result['errmsg'];
                \Log::error($errorMsg);
                return Response::error($errorMsg);
            }
            
            if (!isset($result['openid'])) {
                \Log::error('微信接口返回数据异常：缺少 openid');
                return Response::error('微信登录返回数据异常');
            }
            
            return Response::success($result);
        } catch (Exception $e) {
            $errorMsg = '微信登陆异常: ' . $e->getMessage();
            \Log::error($errorMsg);
            return Response::error($errorMsg);
        }
    }
    
    /**
     * 小程序码
     *    
     * @param string $scene     B接口自定义参数
     * @param array  $optional  参数 [
     *      page            小程序路径例子：pages/pxvote/px-vote/px-player/px-player 必须是已发布的小程序 pages 前面不要/
     *      widht           二维码宽度（默认600）
     *      env_version     要打开的小程序版本。正式版为 "release"，体验版为 "trial"，开发版为 "develop"。默认是正式版。
     *      check_path      false
     * 
     * @return void
     */
    public function getQrcode($scene, $optional,$userId)
    {
        $result = $this->app->app_code->getUnlimit($scene, $optional);
        // 保存二维码
        if ($result instanceof \EasyWeChat\Kernel\Http\StreamResponse) {
            // 直接保存到文件
            $content = $result->getBody()->getContents(); // 二进制内容
            $type = getimagesizefromstring($content)['mime']; //获取二进制流图片格式
            $base64String = 'data:' . $type . ';base64,' . chunk_split(base64_encode($content));
            $uploadTool = new UploadTool();
            $path = $uploadTool->base64Pic($base64String, 'upload/index', $userId);
            if (!$path) {
                return Response::error('小程序码保存失败!');
            }
            return Response::success($path);
        }
        \Log::error('小程序码生成失败: ' . json_encode($result));
        return Response::error('小程序码生成失败');
    }

    /**
     * 获取手机号
     *
     * @param string $code      微信获取手机号专用code
     * @param string $mobile    手机号
     */
    public function mobile($code)
    {
        try {
            $url = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=" . $this->accessToken();
            $data = [
                'code' => $code
            ];
            $data = jsonEncode($data);
            $result = curlPost($url, $data);
            if (isset($result['errcode'])) {
                \Log::error('获取手机号失败: ' . $result['errmsg']);
                throw new ApiException($result['errmsg']);
            }
            return Response::success($result['phone_info']['phoneNumber']);
        } catch (Exception $e) {
            return Response::error('发送失败!');
        }
    }
    
        public function getQrcode1($data)
    {

        $access_token = $this->accessToken(); //获取cache里面的access_token
        //拼接请求的url地址
        $url="https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={$access_token}";
        //参数转为json类型
        $data=json_encode($data);
        //开始请求拿到二维码
        $result = curlPost($url,$data);

        //调用方法，将二维码转为base64返回给前端
        $res = $this->UploadImageQrCode($result);

        return $res;
    }
    public function urlscheme($data1){
        $url1 = 'https://api.weixin.qq.com/wxa/generatescheme?access_token='.$this->accessToken();
        $ch = curl_init();
        // $data1 = array("path"=>"", "query"=>"","env_version"=>"release");
        $data = json_encode(array("expire_type"=>1,"expire_interval"=>5,"jump_wxa"=>$data1));
        curl_setopt($ch, CURLOPT_URL, $url1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }
    public function UploadImageQrCode($img){
		$saveimgfile_1 = './uploads/code';
		$fileimgname = time()."-".rand(1000,9999).".png";
	    $filecachs = $saveimgfile_1."/".$fileimgname;
		$fanhuistr = file_put_contents($filecachs,$img);
		return 'uploads/code/'.$fileimgname;
   	}
}
