<?php
/* ==========================================================================
   Adminer-BHQ (V15 Fixed) - 修复 array_slice 笔误 + 完美记忆
   ========================================================================== */
session_start();
ini_set('display_errors', 0); 
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING & ~E_DEPRECATED);
if (function_exists('mysqli_report')) { mysqli_report(MYSQLI_REPORT_OFF); }

// --- 1. LFI 胶水函数 ---
function build_url($new_params = []) {
    $merged = $_GET; 
    foreach ($new_params as $key => $val) {
        if ($val === null) unset($merged[$key]);
        else $merged[$key] = $val;
    }
    return '?' . http_build_query($merged);
}

// --- 2. JS 强力跳转 ---
function js_redirect($url = '') {
    $target = empty($url) ? 'window.location.href' : '"'.$url.'"';
    echo '<script>window.location.href = ' . $target . ';</script>';
    exit;
}

// --- 3. 历史记录系统 (核心修复区) ---
if (!isset($_SESSION['ad_history'])) $_SESSION['ad_history'] = [];

function add_history($host, $user, $pass, $db) {
    if (empty($db)) return;
    $key = md5($host . $user . $db);
    $newItem = ['host'=>$host, 'user'=>$user, 'pass'=>$pass, 'db'=>$db];
    if (isset($_SESSION['ad_history'][$key])) unset($_SESSION['ad_history'][$key]);
    
    // 插入到最前面
    $_SESSION['ad_history'] = [$key => $newItem] + $_SESSION['ad_history'];
    
    // 【修复】之前的版本写成了 10, 10，导致存进去就没了！现在修正为 0, 10
    $_SESSION['ad_history'] = array_slice($_SESSION['ad_history'], 0, 10, true);
}

// 自动抓取 POST 进入的数据库 (监听列表点击)
if (isset($_POST['nav_enter_db']) && isset($_SESSION['db_pass'])) {
    add_history($_SESSION['db_host'], $_SESSION['db_user'], $_SESSION['db_pass'], $_POST['nav_enter_db']);
}

// --- 4. 业务逻辑 ---

// [返回登录页]
if (isset($_GET['back_login'])) {
    unset($_SESSION['adminer_logged_in']);
    js_redirect(build_url(['back_login' => null])); 
}

// [快捷登录]：点击历史记录 -> 自动登录
if (isset($_GET['autologin']) && isset($_SESSION['ad_history'][$_GET['autologin']])) {
    $creds = $_SESSION['ad_history'][$_GET['autologin']];
    $test_conn = @new mysqli($creds['host'], $creds['user'], $creds['pass']);
    if (!$test_conn->connect_error) {
        $test_conn->close();
        $_SESSION['adminer_logged_in'] = true;
        $_SESSION['db_host'] = $creds['host'];
        $_SESSION['db_user'] = $creds['user'];
        $_SESSION['db_pass'] = $creds['pass'];
        
        // 刷新顺序
        add_history($creds['host'], $creds['user'], $creds['pass'], $creds['db']);
        
        // 跳转
        js_redirect(build_url(['autologin'=>null, 'view'=>'tables', 'db'=>$creds['db'], 'table'=>null]));
    }
}

// [常规登录]
$auth_error = '';
if (isset($_POST['auth_login'])) {
    $server = trim($_POST['auth_server']);
    $user   = trim($_POST['auth_username']);
    $pass   = $_POST['auth_password'];
    $db     = trim($_POST['auth_db']);

    $test_conn = @new mysqli($server, $user, $pass);
    if ($test_conn->connect_error) {
        $auth_error = "Login Failed: " . $test_conn->connect_error;
    } else {
        $_SESSION['adminer_logged_in'] = true;
        $_SESSION['db_host'] = $server;
        $_SESSION['db_user'] = $user;
        $_SESSION['db_pass'] = $pass;
        $test_conn->close();
        
        if ($db) add_history($server, $user, $pass, $db);
        
        // URL 清洗逻辑
        if ($db) {
            js_redirect(build_url(['view'=>'tables', 'db'=>$db, 'table'=>null]));
        } else {
            js_redirect(build_url(['view'=>'dbs', 'db'=>null, 'table'=>null]));
        }
    }
}

// --- 5. 样式 ---
?>
<style>
    body { font-family:"Microsoft YaHei", sans-serif; font-size:13px; background:#f4f4f4; margin:0; padding:10px; }
    a { text-decoration:none; color:#005fcc; }
    /* 表格修复 */
    table.data-table { border-collapse: collapse; width: 100%; margin-top: 5px; font-size:13px; background:#fff; }
    table.data-table th, table.data-table td { border: 1px solid #ccc; padding: 6px 8px; text-align: left; }
    table.data-table th { background: #f2f2f2; color:#333; }
    
    /* 登录页布局 */
    .login-container { display: flex; width: 600px; margin: 80px auto; background: #fff; box-shadow: 0 5px 15px rgba(0,0,0,0.1); border-radius: 4px; overflow: hidden; }
    .login-left { width: 220px; background: #f9f9f9; border-right: 1px solid #eee; padding: 20px; }
    .history-title { margin: 0 0 15px 0; font-size: 14px; color: #666; font-weight: bold; border-bottom: 2px solid #ddd; padding-bottom: 5px; }
    .history-item { display: block; padding: 10px; background: #fff; border: 1px solid #e0e0e0; margin-bottom: 8px; border-radius: 3px; transition: 0.2s; cursor: pointer; }
    .history-item:hover { border-color: #005fcc; background: #f0f8ff; transform: translateX(3px); }
    .h-db { font-weight: bold; color: #333; display: block; margin-bottom: 2px; }
    .h-info { font-size: 11px; color: #999; }
    .login-right { flex: 1; padding: 30px; background: #fff; }
    .login-title { margin: 0 0 20px 0; font-size: 20px; color: #333; font-weight: normal; border-bottom: 2px solid #005fcc; padding-bottom: 10px; display: inline-block; }
    .form-row { margin-bottom: 15px; }
    .form-label { display: block; font-weight: bold; font-size: 12px; color: #555; margin-bottom: 5px; }
    .form-input { width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box; }
    .btn-submit { width: 100%; padding: 10px; background: #005fcc; color: #fff; border: none; border-radius: 3px; font-weight: bold; cursor: pointer; margin-top: 10px; }
</style>
<?php

// --- 6. 登录界面 ---
if (empty($_SESSION['adminer_logged_in'])) {
    ?>
    <div class="login-container">
        <div class="login-left">
            <div class="history-title">最近访问 (History)</div>
            <?php if (empty($_SESSION['ad_history'])): ?>
                <div style="color:#999; font-size:12px; font-style:italic;">暂无历史记录...</div>
            <?php else: ?>
                <?php foreach ($_SESSION['ad_history'] as $key => $h): ?>
                    <a href="<?php echo h(build_url(['autologin'=>$key])); ?>" class="history-item" title="点击直接登录">
                        <span class="h-db">🛢️ <?php echo htmlspecialchars($h['db']); ?></span>
                        <span class="h-info"><?php echo htmlspecialchars($h['user']); ?></span>
                    </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        <div class="login-right">
            <h2 class="login-title">Adminer Login</h2>
            <?php if ($auth_error): ?><div style="background:#fee; color:red; padding:10px; margin-bottom:15px; border-radius:3px; font-size:12px;"><?php echo htmlspecialchars($auth_error); ?></div><?php endif; ?>
            <form action="" method="post">
                <div class="form-row"><label class="form-label">Server</label><input type="text" name="auth_server" value="localhost" class="form-input"></div>
                <div class="form-row"><label class="form-label">Username</label><input type="text" name="auth_username" value="root" class="form-input"></div>
                <div class="form-row"><label class="form-label">Password</label><input type="password" name="auth_password" class="form-input"></div>
                <div class="form-row"><label class="form-label">Database (选填)</label><input type="text" name="auth_db" class="form-input"></div>
                <button type="submit" name="auth_login" class="btn-submit">登 录</button>
            </form>
        </div>
    </div>
    <?php
    exit(); 
}

// 7. 数据库连接与环境初始化
$view  = isset($_REQUEST['view']) ? $_REQUEST['view'] : 'dbs';
$db    = isset($_REQUEST['db']) ? $_REQUEST['db'] : '';
$table = isset($_REQUEST['table']) ? $_REQUEST['table'] : '';

$conn = @new mysqli($_SESSION['db_host'], $_SESSION['db_user'], $_SESSION['db_pass']);
if ($conn->connect_error) { unset($_SESSION['adminer_logged_in']); js_redirect(build_url(['back_login' => null])); }
@$conn->set_charset("utf8mb4");

// 显式选择数据库
if ($db) {
    $conn->select_db($db);
}

// 首页逻辑修正
if ($view === 'dbs') { $db = ''; $table = ''; }

/* 下面紧接 function h($str)... */
/* ==========================================================================
   核心工具函数
   ========================================================================== */

function h($str) {
    // 关键修复：强制转为 string，防止 null 报错
    return htmlspecialchars((string)$str, ENT_QUOTES, 'UTF-8');
}

// 兼容性截取字符串函数（修复白屏问题的核心）
function safe_truncate($str, $width) {
    // 关键修复：强制转为 string，防止 PHP 8+ 传递 int/float 导致 Fatal Error
    $str = (string)$str;
    if ($str === '') return '';
    
    if (function_exists('mb_strimwidth')) {
        // 显式指定 UTF-8，防止编码识别错误
        return mb_strimwidth($str, 0, $width, '...', 'UTF-8');
    }
    // 降级处理
    return strlen($str) > $width ? substr($str, 0, $width) . '...' : $str;
}

function safe_name($name) {
    // 允许任意非空字符串作为库名/表名
    if (!is_string($name) || $name === '') return null;
    return $name;
}

function get_param($key) {
    $val = isset($_POST[$key]) ? $_POST[$key] : (isset($_GET[$key]) ? $_GET[$key] : null);
    if (is_string($val)) return trim($val);
    return $val;
}

function get_primary_key($conn, $table) {
    $tableEsc = '`' . $conn->real_escape_string($table) . '`';
    $res = $conn->query("SHOW KEYS FROM $tableEsc WHERE Key_name = 'PRIMARY'");
    if ($res && $row = $res->fetch_assoc()) return $row['Column_name'];
    return null;
}

/* ==========================================================================
   路由与参数处理
   ========================================================================== */

$view  = get_param('view') ?: 'dbs';
$db    = get_param('db');
$table = get_param('table');
$page  = max(1, intval(get_param('page') ?: 1));
$msg   = '';
$msg_type = 'success';

// 拦截侧边栏导航点击 (POST 路由)
if (isset($_POST['nav_enter_db'])) {
    $view = 'tables';
    $db = safe_name($_POST['nav_enter_db']);
}
if (isset($_POST['nav_enter_table'])) {
    $view = 'data';
    $table = safe_name($_POST['nav_enter_table']);
    $page = 1;
}
if (isset($_POST['nav_edit_row'])) {
    $view = 'edit';
    $_POST['pk'] = $_POST['nav_edit_row']; // 将按钮值传给 pk 参数
}

// 选中数据库
if ($db) {
    if (!$conn->select_db($db)) {
        $msg = "无法进入数据库 [" . h($db) . "]: " . $conn->error;
        $msg_type = "error";
        $view = 'dbs'; 
        $db = null;
    }
}

/* ==========================================================================
   逻辑处理区 (导出/批量操作/保存)
   ========================================================================== */

// 1. 导出下载
if ($view === 'export_download' && $db) {
    $tablesToExport = [];
    if ($table) {
        $tablesToExport[] = $table;
        $filename = $db . "_" . $table . ".sql";
    } else {
        $res = $conn->query("SHOW TABLES");
        while ($row = $res->fetch_array()) $tablesToExport[] = $row[0];
        $filename = $db . "_" . date("Ymd_His") . ".sql";
    }

    ob_end_clean();
    header('Content-Type: application/octet-stream');
    header("Content-Transfer-Encoding: Binary");
    header("Content-disposition: attachment; filename=\"" . $filename . "\"");

    echo "-- Adminer-BH Export\n-- Database: $db\n\nSET NAMES utf8mb4;\nSET foreign_key_checks = 0;\n\n";
    foreach ($tablesToExport as $tb) {
        $tbEsc = '`' . $conn->real_escape_string($tb) . '`';
        echo "DROP TABLE IF EXISTS $tbEsc;\n";
        $res = $conn->query("SHOW CREATE TABLE $tbEsc");
        if ($row = $res->fetch_array()) echo $row[1] . ";\n\n";
        
        $res = $conn->query("SELECT * FROM $tbEsc");
        while ($row = $res->fetch_assoc()) {
            $vals = [];
            foreach ($row as $val) {
                $vals[] = ($val === null) ? "NULL" : "'" . $conn->real_escape_string($val) . "'";
            }
            echo "INSERT INTO $tbEsc VALUES (" . implode(", ", $vals) . ");\n";
        }
        echo "\n";
    }
    echo "SET foreign_key_checks = 1;\n";
    exit;
}

// 2. 表批量操作
if ($view === 'table_batch_action' && $db && !empty($_POST['tables'])) {
    $action = $_POST['action'];
    $targets = $_POST['tables'];
    $count = 0;
    foreach ($targets as $tb) {
        $tbEsc = '`' . $conn->real_escape_string($tb) . '`';
        if ($action === 'truncate') {
            if ($conn->query("TRUNCATE TABLE $tbEsc")) $count++;
        } elseif ($action === 'drop') {
            if ($conn->query("DROP TABLE $tbEsc")) $count++;
        }
    }
    $msg = ($action == 'truncate' ? "清空" : "删除") . "了 $count 个表。";
    $view = 'tables';
}

// 3. 数据批量操作
if ($view === 'data_batch_action' && $db && $table && !empty($_POST['check'])) {
    $action = $_POST['action'];
    $ids = $_POST['check'];
    $pk = get_primary_key($conn, $table);
    $tableEsc = '`' . $conn->real_escape_string($table) . '`';
    
    if ($pk) {
        $pkEsc = '`' . $conn->real_escape_string($pk) . '`';
        $count = 0;
        if ($action === 'delete') {
            foreach ($ids as $id) {
                $idEsc = "'" . $conn->real_escape_string($id) . "'";
                if ($conn->query("DELETE FROM $tableEsc WHERE $pkEsc = $idEsc LIMIT 1")) $count++;
            }
            $msg = "已删除 $count 条记录。";
        } elseif ($action === 'clone') {
            foreach ($ids as $id) {
                $idEsc = "'" . $conn->real_escape_string($id) . "'";
                $res = $conn->query("SELECT * FROM $tableEsc WHERE $pkEsc = $idEsc LIMIT 1");
                if ($res && $row = $res->fetch_assoc()) {
                    $cols = []; $vals = [];
                    foreach ($row as $k => $v) {
                        if ($k === $pk) continue; 
                        $cols[] = "`" . $conn->real_escape_string($k) . "`";
                        $vals[] = ($v === null) ? "NULL" : "'" . $conn->real_escape_string($v) . "'";
                    }
                    $sql = "INSERT INTO $tableEsc (" . implode(',', $cols) . ") VALUES (" . implode(',', $vals) . ")";
                    if ($conn->query($sql)) $count++;
                }
            }
            $msg = "已复制 $count 条记录。";
        }
    } else {
        $msg = "表无主键，无法批量操作。";
        $msg_type = "error";
    }
    $view = 'data';
}

// 4. 保存数据
if (($view === 'save_data') && $db && $table) {
    $pk = get_primary_key($conn, $table);
    $tableEsc = '`' . $conn->real_escape_string($table) . '`';
    $isEdit = !empty($_POST['pk_origin_val']);
    
    $cols = []; $vals = []; $set = [];
    $structure = [];
    $resStr = $conn->query("SHOW COLUMNS FROM $tableEsc");
    while($r = $resStr->fetch_assoc()) $structure[$r['Field']] = $r;

    foreach ($_POST['fields'] as $col => $val) {
        $is_null = isset($_POST['fields_null'][$col]);
        $colInfo = $structure[$col] ?? null;
        if (!$isEdit && $colInfo && stripos($colInfo['Extra'], 'auto_increment') !== false && $val === '') continue;

        $colEsc = '`' . $conn->real_escape_string($col) . '`';
        $valSql = $is_null ? "NULL" : "'" . $conn->real_escape_string($val) . "'";
        $cols[] = $colEsc;
        $vals[] = $valSql;
        $set[]  = "$colEsc = $valSql";
    }

    if ($isEdit) {
        $pkValOriginal = $_POST['pk_origin_val'];
        $pkEsc = '`' . $conn->real_escape_string($pk) . '`';
        $sql = "UPDATE $tableEsc SET " . implode(", ", $set) . " WHERE $pkEsc = '" . $conn->real_escape_string($pkValOriginal) . "'";
        if ($conn->query($sql)) $msg = "记录已更新。";
        else { $msg = "更新失败: " . $conn->error; $msg_type = "error"; }
        $view = 'data';
    } else {
        $sql = "INSERT INTO $tableEsc (" . implode(',', $cols) . ") VALUES (" . implode(',', $vals) . ")";
        if ($conn->query($sql)) {
            $msg = "插入成功，ID: " . $conn->insert_id;
            $view = 'data';
        } else {
            $msg = "插入失败: " . $conn->error;
            $msg_type = "error";
            $view = 'insert';
        }
    }
}

// 5. 导入执行
if ($view === 'import_exec' && $db) {
    $content = '';
    if (!empty($_FILES['sql_file']['tmp_name'])) $content = file_get_contents($_FILES['sql_file']['tmp_name']);
    elseif (!empty($_POST['sql_content'])) $content = $_POST['sql_content'];
    
    if ($content) {
        if ($conn->multi_query($content)) {
            do { if ($res = $conn->store_result()) $res->free(); } while ($conn->more_results() && $conn->next_result());
            $msg = "SQL 导入执行完成。";
        } else {
            $msg = "执行错误: " . $conn->error;
            $msg_type = "error";
        }
    }
    $view = 'import';
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
<meta charset="UTF-8">
<title>Adminer-BH <?php echo $db ? "- ".h($db) : ""; ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
    :root { --blue: #0045c2; --bg: #fff; --gray: #f3f3f3; --border: #ccc; --th: #e8eef9; --hover: #fdf8ff; }
    body { font-family: sans-serif; font-size: 13px; margin: 0; padding: 0; display: flex; height: 100vh; color: #333; }
    
    /* 侧边栏 */
    .sidebar { width: 240px; background: var(--gray); border-right: 1px solid #999; display: flex; flex-direction: column; padding: 10px; overflow-y: auto; flex-shrink: 0; }
    .sidebar h2 { margin: 0 0 10px; font-size: 20px; color: #666; font-style: italic; }
    .sidebar h2 span { color: #f00; }
    .db-current { font-weight: bold; margin-bottom: 5px; word-break: break-all; }
    
    .table-nav { list-style: none; padding: 0; margin: 5px 0 0 0; border-top: 1px solid #ccc; padding-top:5px; }
    .table-nav li { margin: 0; padding: 0; }
    
    /* 关键修复：侧边栏表名按钮样式 */
    .table-nav button.t-btn { 
        display: block; width: 100%; padding: 3px 5px; 
        border: none; background: none; text-align: left;
        cursor: pointer; color: var(--blue); border-radius: 2px;
        line-height: 1.3; font-size: 13px;
    }
    .table-nav button.t-btn:hover { background: #e0e0e0; text-decoration: none; color: #000; }
    .table-nav button.active { background: #ccc; font-weight: bold; color: #000; }
    
    /* 注释样式 */
    .t-comment { color: #999; font-size: 11px; margin-left: 5px; font-weight: normal; display: inline-block; }

    /* 主体 */
    .main { flex: 1; padding: 15px; overflow-y: auto; display: flex; flex-direction: column; }
    .breadcrumb { border-bottom: 1px solid #ccc; padding-bottom: 5px; margin-bottom: 15px; font-size: 14px; }
    
    button.link { background: none; border: none; padding: 0; font-size: inherit; color: var(--blue); cursor: pointer; text-align: left; }
    button.link:hover { text-decoration: underline; color: #e62e00; }

    .tabs { margin-bottom: 10px; border-bottom: 1px solid #ddd; }
    .tabs button { display: inline-block; padding: 5px 10px; margin-right: 5px; margin-bottom: -1px; border: 1px solid transparent; background: none; color: var(--blue); cursor: pointer; font-size: 13px; }
    .tabs button:hover { text-decoration: underline; }
    .tabs button.active { border-color: #ddd; border-bottom-color: #fff; background: #fff; font-weight: bold; color: #000; border-radius: 3px 3px 0 0; text-decoration: none; }
    
    .data-table { width: 100%; border-collapse: collapse; border: 1px solid #999; font-size: 13px; margin-bottom: 10px; }
    .data-table th, .data-table td { border: 1px solid #ccc; padding: 3px 6px; text-align: left; vertical-align: top; }
    .data-table th { background: var(--th); white-space: nowrap; cursor: default; }
    .data-table tr:nth-child(even) { background: #f9f9f9; }
    .data-table tr:hover { background: var(--hover); }
    .data-table td.check { width: 20px; text-align: center; background: #f0f0f0; }
    
    .filter { background: #f5f5f5; border: 1px solid #ccc; padding: 5px; margin-bottom: 10px; }
    .filter fieldset { display: inline-block; border: 1px solid #aaa; margin: 0 5px 0 0; padding: 2px 5px; vertical-align: middle; background: #fff; }
    .filter legend { font-size: 11px; font-weight: bold; color: #666; padding: 0 2px; }
    input, select, textarea { font-size: 12px; padding: 2px; border: 1px solid #999; }
    
    .btn { cursor: pointer; padding: 2px 8px; border: 1px solid #aaa; background: #eee; border-radius: 2px; font-size: 12px; color: #000; }
    .btn:hover { background: #ddd; }
    .btn-red { color: #c00; border-color: #c00; }
    
    .msg { padding: 10px; margin-bottom: 15px; border: 1px solid transparent; }
    .msg.success { background: #e6efc2; border-color: #c6d880; color: #264409; }
    .msg.error { background: #fce3e3; border-color: #f1acac; color: #8a1f11; }
    .actions-bar { margin-top: 5px; padding: 5px; background: #f9f9f9; border: 1px solid #eee; }
    .pager { margin-top: 10px; text-align: center; background: #f9f9f9; padding: 5px; border: 1px solid #eee; }
    .sql { font-family: monospace; background: #f9f9f9; padding: 5px; border: 1px solid #eee; margin-bottom: 10px; color: green; max-height: 100px; overflow: auto; }
</style>
<script>
    function toggleAll(source, name) {
        var checkboxes = document.getElementsByName(name);
        for(var i=0, n=checkboxes.length;i<n;i++) checkboxes[i].checked = source.checked;
        updateCount();
    }
    function updateCount() {
        var el = document.getElementById('selected-count');
        if(el) {
            var checked = document.querySelectorAll('input[name="check[]"]:checked').length;
            el.innerText = checked;
        }
    }
</script>
</head>
<body>

<div class="sidebar">
    <h2>Adminer <span>BH</span></h2>
    <form method="post" style="margin:0;"><input type="hidden" name="view" value="dbs"><button type="submit" class="link" style="font-weight:bold;">[数据库列表]</button></form>    <?php echo '<th>数据库名 <a href="'.h(build_url(['back_login'=>1])).'" style="float:right; font-weight:normal; font-size:12px; color:#d32f2f; border:1px solid #d32f2f; padding:1px 5px; border-radius:3px; text-decoration:none;">[⬅ 返回登录页]</a></th>';?>
    <br>
    <?php if ($db): ?>
        <div class="db-current">📂 <?php echo h($db); ?></div>
        <div style="margin-bottom:5px;">
            <form method="post" style="display:inline"><input type="hidden" name="view" value="sql"><input type="hidden" name="db" value="<?php echo h($db); ?>"><button type="submit" class="link" style="color:green">[SQL]</button></form>
            <form method="post" style="display:inline"><input type="hidden" name="view" value="import"><input type="hidden" name="db" value="<?php echo h($db); ?>"><button type="submit" class="link" style="color:purple">[导入]</button></form>
            <form method="post" style="display:inline"><input type="hidden" name="view" value="export"><input type="hidden" name="db" value="<?php echo h($db); ?>"><button type="submit" class="link" style="color:blue">[导出]</button></form>
        </div>
        <ul class="table-nav">
        <?php
        // 侧边栏表列表
        if ($conn->select_db($db)) {
            $res = $conn->query("SELECT TABLE_NAME, TABLE_COMMENT FROM information_schema.TABLES WHERE TABLE_SCHEMA = '".$conn->real_escape_string($db)."' ORDER BY TABLE_NAME");
            if ($res) {
                while ($row = $res->fetch_assoc()) {
                    $t = $row['TABLE_NAME'];
                    $isActive = ($table === $t);
                    // 表名提交按钮
                    echo '<li>';
                    echo '<form method="post" style="margin:0;">';
                    echo '<input type="hidden" name="nav_enter_table" value="'.h($t).'">';
                    echo '<input type="hidden" name="db" value="'.h($db).'">';
                    echo '<button type="submit" class="t-btn '.($isActive?'active':'').'">';
                    echo h($t);
                    if ($row['TABLE_COMMENT']) echo '<span class="t-comment">'.h($row['TABLE_COMMENT']).'</span>';
                    echo '</button></form>';
                    echo '</li>';
                }
            }
        }
        ?>
        </ul>
    <?php endif; ?>
</div>

<div class="main">
    <?php if ($msg): ?>
        <div class="msg <?php echo $msg_type; ?>"><?php echo h($msg); ?></div>
    <?php endif; ?>

    <div class="breadcrumb">
        <form method="post" style="display:inline"><input type="hidden" name="view" value="dbs"><button type="submit" class="link">数据库</button></form>
        <?php if ($db): ?>
            &raquo; <form method="post" style="display:inline"><input type="hidden" name="nav_enter_db" value="<?php echo h($db); ?>"><button type="submit" class="link"><?php echo h($db); ?></button></form>
        <?php endif; ?>
        <?php if ($table): ?>
            &raquo; <b><?php echo h($table); ?></b>
        <?php endif; ?>
    </div>

    <?php if ($db && $table && !in_array($view, ['import','export','sql'])): ?>
    <div class="tabs">
        <?php 
        $tabs = [
            'data' => '选择数据',
            'structure' => '显示结构',
            'insert' => '新建数据',
            'copycreate' => '建表语句'
        ];
        foreach($tabs as $v => $l) {
            $cls = ($view === $v) ? 'active' : '';
            echo '<form method="post" style="display:inline"><input type="hidden" name="view" value="'.$v.'"><input type="hidden" name="db" value="'.h($db).'"><input type="hidden" name="table" value="'.h($table).'"><button type="submit" class="'.$cls.'">'.$l.'</button></form>';
        }
        ?>
        <div style="float:right">
            <form method="post" style="display:inline" onsubmit="return confirm('确定清空表？')">
                <input type="hidden" name="view" value="table_batch_action">
                <input type="hidden" name="action" value="truncate">
                <input type="hidden" name="db" value="<?php echo h($db); ?>">
                <input type="hidden" name="tables[]" value="<?php echo h($table); ?>">
                <button type="submit" class="link" style="color:red">⚠️ 清空表</button>
            </form>
        </div>
    </div>
    <?php endif; ?>

    <?php
    /* -------------------------- 
       1. 数据库列表
       -------------------------- */
    if ($view === 'dbs') {
        // 修改开始：添加返回登录页按钮
        echo '<h3>数据库</h3>';
        $res = $conn->query("SHOW DATABASES");
        echo '<table class="data-table"><thead><tr><th>数据库名</th><th>校对规则</th></tr></thead><tbody>';
        while ($row = $res->fetch_row()) { 
            $d = $row[0];
            echo '<tr><td>';
            echo '<form method="post" style="margin:0;">';
            echo '<input type="hidden" name="nav_enter_db" value="'.h($d).'">';
            echo '<button type="submit" class="link" style="font-weight:bold">'.h($d).'</button>';
            echo '</form>';
            echo '</td><td>-</td></tr>';
        }
        echo '</tbody></table>';
    }

    /* -------------------------- 
       2. 表列表
       -------------------------- */
    elseif ($view === 'tables' && $db) {
        echo '<form method="post" action="">';
        echo '<input type="hidden" name="view" value="table_batch_action">';
        echo '<input type="hidden" name="db" value="'.h($db).'">';
        
        echo '<table class="data-table"><thead><tr>
            <th class="check"><input type="checkbox" onclick="toggleAll(this, \'tables[]\')"></th>
            <th>表名</th><th>行数</th><th>大小</th><th>自增</th><th>注释</th>
        </tr></thead><tbody>';
        
        $res = $conn->query("SHOW TABLE STATUS");
        if ($res) {
            while ($row = $res->fetch_assoc()) {
                echo '<tr>';
                echo '<td class="check"><input type="checkbox" name="tables[]" value="'.h($row['Name']).'"></td>';
                echo '<td><button type="submit" name="nav_enter_table" value="'.h($row['Name']).'" class="link" style="font-weight:bold">'.h($row['Name']).'</button></td>';
                echo '<td>'.$row['Rows'].'</td>';
                echo '<td>'.round(($row['Data_length']+$row['Index_length'])/1024, 2).' KB</td>';
                echo '<td>'.$row['Auto_increment'].'</td>';
                echo '<td>'.h($row['Comment']).'</td>';
                echo '</tr>';
            }
        }
        echo '</tbody></table>';
        echo '<div class="actions-bar">已选中: <button type="submit" name="action" value="truncate" class="btn btn-red" onclick="return confirm(\'确定清空选中的表？\')">清空 (Truncate)</button> <button type="submit" name="action" value="drop" class="btn btn-red" onclick="return confirm(\'确定删除选中的表？\')">删除 (Drop)</button></div></form>';
    }

    /* -------------------------- 
       3. 数据浏览
       -------------------------- */
    elseif ($view === 'data' && $db && $table) {
        $filter_col = $_POST['filter_col'] ?? '';
        $filter_op = $_POST['filter_op'] ?? '=';
        $filter_val = $_POST['filter_val'] ?? '';
        $limit = intval($_POST['limit'] ?? 50);
        $where = "";
        
        // 筛选器
        echo '<form method="post" class="filter">';
        echo '<input type="hidden" name="view" value="data">';
        echo '<input type="hidden" name="db" value="'.h($db).'">';
        echo '<input type="hidden" name="table" value="'.h($table).'">';
        echo '<input type="hidden" name="page" value="1">';
        echo '<fieldset><legend>筛选</legend>';
        $cols = []; 
        $res = $conn->query("SHOW COLUMNS FROM `".$conn->real_escape_string($table)."`");
        if ($res) while($r=$res->fetch_assoc()) $cols[] = $r['Field'];
        
        echo '<select name="filter_col"><option value="">(列)</option>';
        foreach($cols as $c) echo '<option value="'.h($c).'" '.($filter_col==$c?'selected':'').'>'.h($c).'</option>';
        echo '</select> <select name="filter_op">';
        foreach(['='=>'=','LIKE'=>'LIKE','>'=>'>','<'=>'<'] as $k=>$v) echo '<option value="'.$k.'" '.($filter_op==$k?'selected':'').'>'.$v.'</option>';
        echo '</select> <input name="filter_val" value="'.h($filter_val).'"></fieldset>';
        echo '<fieldset><legend>限制</legend><input type="number" name="limit" value="'.$limit.'" style="width:50px"></fieldset><button type="submit" class="btn">选择</button></form>';

        // 查询
        $tableEsc = '`' . $conn->real_escape_string($table) . '`';
        if ($filter_col && $filter_val !== '') {
            $f_col = '`' . $conn->real_escape_string($filter_col) . '`';
            $f_val = $conn->real_escape_string($filter_val);
            $where = ($filter_op == 'LIKE') ? " WHERE $f_col LIKE '%$f_val%'" : " WHERE $f_col $filter_op '$f_val'";
        }
        
        $cntRes = $conn->query("SELECT COUNT(*) FROM $tableEsc $where");
        if (!$cntRes) {
            echo "<div class='msg error'>SQL错误: ".h($conn->error)."</div>";
        } else {
            $cnt = $cntRes->fetch_row()[0];
            $offset = ($page - 1) * $limit;
            $sql = "SELECT * FROM $tableEsc $where LIMIT $offset, $limit";
            echo '<div class="sql">'.h($sql).';</div>';
            $res = $conn->query($sql);
            $pk = get_primary_key($conn, $table);

            echo '<form method="post" action="">';
            echo '<input type="hidden" name="view" value="data_batch_action">';
            echo '<input type="hidden" name="db" value="'.h($db).'">';
            echo '<input type="hidden" name="table" value="'.h($table).'">';
            // 保留筛选状态
            echo '<input type="hidden" name="filter_col" value="'.h($filter_col).'">';
            echo '<input type="hidden" name="filter_op" value="'.h($filter_op).'">';
            echo '<input type="hidden" name="filter_val" value="'.h($filter_val).'">';
            echo '<input type="hidden" name="limit" value="'.$limit.'">';
            echo '<input type="hidden" name="page" value="'.$page.'">';
            
            echo '<div style="overflow-x:auto;"><table class="data-table"><thead><tr><th class="check"><input type="checkbox" onclick="toggleAll(this, \'check[]\')"></th><th>修改</th>';
            if ($res) {
                $fields = $res->fetch_fields();
                foreach ($fields as $f) echo '<th>'.h($f->name).'</th>';
                echo '</tr></thead><tbody>';
                while ($row = $res->fetch_assoc()) {
                    echo '<tr>';
                    $pkVal = $pk ? $row[$pk] : null;
                    echo '<td class="check">';
                    if ($pk) echo '<input type="checkbox" name="check[]" value="'.h($pkVal).'" onclick="updateCount()">';
                    echo '</td><td>';
                    if ($pk) echo '<button type="submit" name="nav_edit_row" value="'.h($pkVal).'" class="link">✎ 编辑</button>';
                    echo '</td>';
                    foreach ($row as $val) echo '<td>'.($val === null ? '<i style="color:#aaa">NULL</i>' : h(safe_truncate($val, 60))).'</td>';
                    echo '</tr>';
                }
            }
            echo '</tbody></table></div>';
            echo '<div class="actions-bar">选中项 (<span id="selected-count">0</span>): <button type="submit" name="action" value="clone" class="btn">📄 复制</button> <button type="submit" name="action" value="delete" class="btn btn-red" onclick="return confirm(\'确定删除？\')">❌ 删除</button></div></form>';

             // ========== 增强分页（首尾跳转 + 省略号 + 总行数显示）==========
            $pages = ceil($cnt / $limit);
            if ($pages <= 1) {
                echo '<div class="pager">共 ' . $cnt . ' 条记录</div>';
            } else {
                $show_pages = 5; // 当前页前后各显示几页
                $start = max(1, $page - $show_pages);
                $end   = min($pages, $page + $show_pages);

                echo '<div class="pager" style="display:flex; justify-content:space-between; align-items:center; font-size:14px;">';

                // 左侧页码
                echo '<div style="flex:1;">';

                // 第一页
                if ($page > 1) {
                    echo '<form method="post" style="display:inline"><input type="hidden" name="view" value="data"><input type="hidden" name="db" value="'.h($db).'"><input type="hidden" name="table" value="'.h($table).'"><input type="hidden" name="page" value="1"><input type="hidden" name="limit" value="'.$limit.'">';
                    foreach (['filter_col','filter_op','filter_val'] as $f) {
                        if (isset($_POST[$f])) echo '<input type="hidden" name="'.$f.'" value="'.h($_POST[$f]).'">';
                    }
                    echo '<button type="submit" class="btn" style="min-width:32px;">1</button></form> ';
                } else {
                    echo '<span style="color:#000;font-weight:bold;">1</span> ';
                }

                // 左侧省略号
                if ($start > 2) echo '... ';

                // 中间页码
                for ($i = $start; $i <= $end; $i++) {
                    if ($i == $page) {
                        echo '<span style="background:#0045c2;color:#fff;padding:2px 8px;border-radius:3px;font-weight:bold;">'.$i.'</span> ';
                    } else {
                        echo '<form method="post" style="display:inline"><input type="hidden" name="view" value="data"><input type="hidden" name="db" value="'.h($db).'"><input type="hidden" name="table" value="'.h($table).'"><input type="hidden" name="page" value="'.$i.'"><input type="hidden" name="limit" value="'.$limit.'">';
                        foreach (['filter_col','filter_op','filter_val'] as $f) {
                            if (isset($_POST[$f])) echo '<input type="hidden" name="'.$f.'" value="'.h($_POST[$f]).'">';
                        }
                        echo '<button type="submit" class="btn" style="min-width:32px;">'.$i.'</button></form> ';
                    }
                }

                // 右侧省略号
                if ($end < $pages - 1) echo '... ';

                // 最后一页
                if ($page < $pages) {
                    echo '<form method="post" style="display:inline"><input type="hidden" name="view" value="data"><input type="hidden" name="db" value="'.h($db).'"><input type="hidden" name="table" value="'.h($table).'"><input type="hidden" name="page" value="'.$pages.'"><input type="hidden" name="limit" value="'.$limit.'">';
                    foreach (['filter_col','filter_op','filter_val'] as $f) {
                        if (isset($_POST[$f])) echo '<input type="hidden" name="'.$f.'" value="'.h($_POST[$f]).'">';
                    }
                    echo '<button type="submit" class="btn" style="min-width:32px;">'.$pages.'</button></form>';
                } else {
                    echo '<span style="color:#000;font-weight:bold;">'.$pages.'</span>';
                }

                echo '</div>';

                // 右侧总行数 + 上下页按钮
                echo '<div style="text-align:right; white-space:nowrap;">';
                if ($page > 1) {
                    echo '<form method="post" style="display:inline"><input type="hidden" name="view" value="data"><input type="hidden" name="db" value="'.h($db).'"><input type="hidden" name="table" value="'.h($table).'"><input type="hidden" name="page" value="'.($page-1).'"><input type="hidden" name="limit" value="'.$limit.'">';
                    foreach (['filter_col','filter_op','filter_val'] as $f) if (isset($_POST[$f])) echo '<input type="hidden" name="'.$f.'" value="'.h($_POST[$f]).'">';
                    echo '<button type="submit" class="btn">上一页</button></form> ';
                }
                if ($page < $pages) {
                    echo '<form method="post" style="display:inline"><input type="hidden" name="view" value="data"><input type="hidden" name="db" value="'.h($db).'"><input type="hidden" name="table" value="'.h($table).'"><input type="hidden" name="page" value="'.($page+1).'"><input type="hidden" name="limit" value="'.$limit.'">';
                    foreach (['filter_col','filter_op','filter_val'] as $f) if (isset($_POST[$f])) echo '<input type="hidden" name="'.$f.'" value="'.h($_POST[$f]).'">';
                    echo '<button type="submit" class="btn">下一页</button></form>';
                }
                echo ' &nbsp; <strong>'.$cnt.'</strong> 行';
                echo '</div>';

                echo '</div>'; // .pager
            }
            // ========== 分页结束 ==========
            echo '</div>';
        }
    }

    /* -------------------------- 
       4. 新建/编辑数据
       -------------------------- */
    elseif (($view === 'insert' || $view === 'edit') && $db && $table) {
        $pkVal = $_POST['pk'] ?? null;
        $isEdit = ($view === 'edit' && $pkVal !== null);
        $row = [];
        
        if ($isEdit) {
            echo '<h3>编辑记录</h3>';
            $pkName = get_primary_key($conn, $table);
            $tableEsc = '`' . $conn->real_escape_string($table) . '`';
            $pkEsc = '`' . $conn->real_escape_string($pkName) . '`';
            $res = $conn->query("SELECT * FROM $tableEsc WHERE $pkEsc = '" . $conn->real_escape_string($pkVal) . "'");
            if ($res) $row = $res->fetch_assoc();
        } else echo '<h3>新建数据</h3>';

        $res = $conn->query("SHOW FULL COLUMNS FROM `".$conn->real_escape_string($table)."`");
        echo '<form action="" method="post">';
        echo '<input type="hidden" name="view" value="save_data">';
        echo '<input type="hidden" name="db" value="'.h($db).'">';
        echo '<input type="hidden" name="table" value="'.h($table).'">';
        if ($isEdit) echo '<input type="hidden" name="pk_origin_val" value="'.h($pkVal).'">';
        
        echo '<table class="data-table"><thead><tr><th>列名</th><th>类型</th><th>值</th><th>Null</th><th>注释</th></tr></thead><tbody>';
        while ($col = $res->fetch_assoc()) {
            $field = $col['Field'];
            $val = $isEdit ? ($row[$field] ?? '') : ($col['Default'] ?? '');
            $isNull = $isEdit ? ($row[$field] === null) : false;
            echo '<tr><td>'.h($field).'</td><td>'.h($col['Type']).'</td><td>';
            if (strpos($col['Type'], 'text') !== false) echo '<textarea name="fields['.h($field).']">'.h($val).'</textarea>';
            else echo '<input type="text" name="fields['.h($field).']" value="'.h($val).'" style="width:100%">';
            echo '</td><td><input type="checkbox" name="fields_null['.h($field).']" value="1" '.($isNull?'checked':'').'></td><td style="color:#888;font-size:11px">'.h($col['Comment']).'</td></tr>';
        }
        echo '</tbody></table><button type="submit" class="btn" style="padding:5px 15px;font-weight:bold">保存</button></form>';
    }

    /* -------------------------- 
       5. 导入
       -------------------------- */
    elseif ($view === 'import' && $db) {
        echo '<h3>导入 SQL 到 '.h($db).'</h3><form action="" method="post" enctype="multipart/form-data">';
        echo '<input type="hidden" name="view" value="import_exec">';
        echo '<input type="hidden" name="db" value="'.h($db).'">';
        echo '<fieldset class="filter" style="display:block"><legend>上传文件</legend><input type="file" name="sql_file" accept=".sql"></fieldset><br><fieldset class="filter" style="display:block"><legend>或粘贴 SQL</legend><textarea name="sql_content" style="width:100%;height:150px"></textarea></fieldset><br><button type="submit" class="btn" style="padding:5px 20px">执行</button></form>';
    }

    /* -------------------------- 
       6. 导出
       -------------------------- */
    elseif ($view === 'export' && $db) {
        echo '<h3>导出数据库 '.h($db).'</h3><p>生成 .sql 文件，包含建表语句和数据。</p>';
        echo '<form action="" method="post">';
        echo '<input type="hidden" name="view" value="export_download">';
        echo '<input type="hidden" name="db" value="'.h($db).'">';
        echo '<button type="submit" class="btn" style="padding:10px 20px;font-size:14px">📥 下载 SQL 文件</button></form>';
    }

    /* -------------------------- 
       7. SQL 命令
       -------------------------- */
    elseif ($view === 'sql' && $db) {
        $query = $_POST['query'] ?? '';
        echo '<h3>SQL 命令</h3><form action="" method="post">';
        echo '<input type="hidden" name="view" value="sql">';
        echo '<input type="hidden" name="db" value="'.h($db).'">';
        echo '<textarea name="query" style="width:100%;height:100px;font-family:monospace;border:1px solid #999">'.h($query).'</textarea><br><button type="submit" class="btn" style="margin-top:5px">执行</button></form>';
        if ($query) {
            echo '<hr>';
            if ($conn->multi_query($query)) {
                do {
                    if ($res = $conn->store_result()) {
                        echo '<p>结果 ('.$res->num_rows.' 行):</p><div style="overflow-x:auto;max-height:300px;"><table class="data-table"><thead><tr>';
                        $fields = $res->fetch_fields();
                        foreach($fields as $f) echo '<th>'.h($f->name).'</th>';
                        echo '</tr></thead><tbody>';
                        while($r = $res->fetch_assoc()) { echo '<tr>'; foreach($r as $v) echo '<td>'.h($v).'</td>'; echo '</tr>'; }
                        echo '</tbody></table></div>';
                        $res->free();
                    } else echo ($conn->errno) ? '<div class="msg error">错误: '.h($conn->error).'</div>' : '<div class="msg success">成功，影响行数: '.$conn->affected_rows.'</div>';
                } while ($conn->more_results() && $conn->next_result());
            } else echo '<div class="msg error">SQL 错误: '.h($conn->error).'</div>';
        }
    }

    /* -------------------------- 
       8. 建表语句 & 结构
       -------------------------- */
    elseif ($view === 'copycreate' && $db && $table) {
        $res = $conn->query("SHOW CREATE TABLE `".$conn->real_escape_string($table)."`");
        echo '<h3>建表语句</h3><textarea style="width:100%;height:300px">'.h($res->fetch_array()[1]).'</textarea>';
    }
    elseif ($view === 'structure' && $db && $table) {
        $res = $conn->query("SHOW FULL COLUMNS FROM `".$conn->real_escape_string($table)."`");
        echo '<h3>表结构</h3><table class="data-table"><thead><tr><th>字段</th><th>类型</th><th>整理</th><th>Null</th><th>Key</th><th>默认</th><th>额外</th><th>注释</th></tr></thead><tbody>';
        while($row = $res->fetch_assoc()) { echo '<tr>'; foreach(['Field','Type','Collation','Null','Key','Default','Extra','Comment'] as $k) echo '<td>'.h($row[$k]).'</td>'; echo '</tr>'; }
        echo '</tbody></table>';
    }
    ?>
</div>
</body>
</html>
<?php $conn->close(); ob_end_flush(); ?>