@extends('admin.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto">
            <h2>添加配置</h2>
        </div>
        <div class="layui-card-body">
            <form class="layui-form" method="post">
                {{csrf_field()}}
                <div class="layui-form-item">
                    <label for="" class="layui-form-label">配置组</label>
                    <div class="layui-input-block">
                        <select name="group_id" lay-verify="required">
                            <option value=""></option>
                            @foreach($groups as $group)
                            <option value="{{$group->id}}">{{$group->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="layui-form-item">
                    <label for="" class="layui-form-label">类型</label>
                    <div class="layui-input-block">
                        <select name="type" >
                            <option value="input">输入框</option>
                            <option value="textarea">文本域</option>
                            <option value="radio">单选</option>
                            <option value="select">下拉</option>
                            <option value="image">图片</option>
                            <option value="audio">音频</option>
                            <option value="video">视频</option>
                            <option value="file">文件</option>
                        </select>
                    </div>
                </div>
                <div class="layui-form-item">
                    <label for="" class="layui-form-label">配置名称</label>
                    <div class="layui-input-block">
                        <input type="text" name="label" value="{{ old('label') }}" lay-verify="required" placeholder="请输入名称" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item">
                    <label for="" class="layui-form-label">配置字段</label>
                    <div class="layui-input-block">
                        <input type="text" name="key" value="{{ old('key') }}" lay-verify="required" placeholder="请输入,如name" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item">
                    <label for="" class="layui-form-label">配置值</label>
                    <div class="layui-input-block">
                        <input type="text" name="val" value="{{ old('val') }}" placeholder="请输入" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item">
                    <label for="" class="layui-form-label">输入提示</label>
                    <div class="layui-input-block">
                        <input type="text" name="tips" value="{{ old('tips') }}" placeholder="请输入" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item">
                    <label for="" class="layui-form-label">配置排序</label>
                    <div class="layui-input-block">
                        <input type="number" name="sort" value="{{ old('sort',0) }}" placeholder="请输入" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-input-block">
                        <button type="submit" class="layui-btn preservation" lay-submit="" lay-filter="formDemo">确 认</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('script')
    <script>
        layui.use(['element', 'form','util'], function() {
            var form = layui.form
            var util = layui.util
            //监听提交
            form.on('submit(formDemo)', function(data) {
                // 禁用提交按钮
                var DISABLED = 'layui-btn-disabled';
                $('.preservation').addClass(DISABLED);
                $('.preservation').attr('disabled', 'disabled');
                // ajax 请求
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "{{route('admin.configuration.store')}}",
                    type: 'POST',
                    data: data.field,
                    async: false,
                    dataType: "json",
                    // 接口成功请求之后的逻辑
                    success: function(res) {
                        if (res['code'] == 200) {
                            // 弹窗
                            layer.msg(res.msg, { icon: 1, time:500},function(){
                                var index = parent.layer.getFrameIndex(window.name); 
                                parent.layer.close(index);
                                window.parent.location.reload();
                            });
                        } else {
                            layer.msg(res.msg, {icon: 2});
                            // 单击之后提交按钮不可选,防止重复提交
                            $('.preservation').removeClass(DISABLED);
                            $('.preservation').removeAttr('disabled');
                        }
                    },
                    // 服务器错误
                    error: function(res) {
                        // 弹窗
                        layer.msg('服务器错误', {icon: 2});
                        // 单击之后提交按钮不可选,防止重复提交
                        $('.preservation').removeClass(DISABLED);
                        $('.preservation').removeAttr('disabled');
                    }
                });
                return false;
            });
        })
    </script>
@endsection