@extends('admin.base')

@section('content')
<div class="layui-row layui-col-space15">
    <div class="layui-col-sm6 layui-col-md3">
        <div class="layui-card">
            <div class="layui-card-header">
                用户总数量
                <a lay-href="{{route('users.users')}}">
                <span class="layui-badge layui-bg-blue layuiadmin-badge">用户列表</span>
                </a>
            </div>
            <div class="layui-card-body layuiadmin-card-list">
                <p class="layuiadmin-big-font">{{$data['user_total']}}</p>
                <p>
                    日新增用户数量
                    <span class="layuiadmin-span-color">{{$data['user_day']}}</span>
                </p>
                <p>
                    月新增用户数量
                    <span class="layuiadmin-span-color">{{$data['user_month']}}</span>
                </p>
            </div>
        </div>
    </div>
    <div class="layui-col-sm6 layui-col-md3">
        <div class="layui-card">
            <div class="layui-card-header">
                订单数量
                <a lay-href="{{route('stats.box')}}">
                <span class="layui-badge layui-bg-blue layuiadmin-badge">开盒记录</span>
                </a>
            </div>
            <div class="layui-card-body layuiadmin-card-list">
                <p class="layuiadmin-big-font">{{$data['order_total']}}</p>
                <p>
                    日新增订单数量
                    <span class="layuiadmin-span-color">{{$data['order_day']}}</span>
                </p>
                <p>
                    月新增订单数量
                    <span class="layuiadmin-span-color">{{$data['order_month']}}</span>
                </p>
            </div>
        </div>
    </div>
    <div class="layui-col-sm6 layui-col-md3">
        <div class="layui-card">
            <div class="layui-card-header">
                充值金额
                <a lay-href="{{route('users.withdraw')}}">
                <span class="layui-badge layui-bg-blue layuiadmin-badge">充值记录</span>
                </a>
            </div>
            <div class="layui-card-body layuiadmin-card-list">
                <p class="layuiadmin-big-font">{{$data['recharge_total']}}</p>
                <p>
                    今日充值金额
                    <span class="layuiadmin-span-color">{{$data['recharge_day']}}</span>
                </p>
                <p>
                    总充值金额
                    <span class="layuiadmin-span-color">{{$data['recharge_total']}}</span>
                </p>
            </div>
        </div>
    </div>
    <div class="layui-col-sm6 layui-col-md3">
        <div class="layui-card">
            <div class="layui-card-header">
                流水
                <a lay-href="{{route('stats.money')}}">
                <span class="layui-badge layui-bg-blue layuiadmin-badge">余额记录</span>
                </a>
            </div>
            <div class="layui-card-body layuiadmin-card-list">
                <p class="layuiadmin-big-font">{{$data['money_total']}}</p>
                <p>
                    日新增流水
                    <span class="layuiadmin-span-color">{{$data['money_day']}}</span>
                </p>
                <p>
                    月新增流水
                    <span class="layuiadmin-span-color">{{$data['money_month']}}</span>
                </p>
            </div>
        </div>
    </div>
        <div class="layui-col-sm6 layui-col-md3">
        <div class="layui-card">
            <div class="layui-card-header">
                用户消费统计
            </div>
            <div class="layui-card-body layuiadmin-card-list">
                <p class="layuiadmin-big-font">{{$data['total_money']}}</p>
                <p>
                    今日消费统计
                    <span class="layuiadmin-span-color">{{$data['day_money']}}</span>
                </p>
                <p>
                    总共消费统计
                    <span class="layuiadmin-span-color">{{$data['total_money']}}</span>
                </p>
            </div>
        </div>
    </div>
    <div class="layui-col-sm12">
        <div class="layui-card">
            <div class="layui-card-body">
                <div id="EchartZhu" style="width:500 ;height:500px;"> </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script src="/static/admin/layuiadmin/echarts.js"></script>
<script>
    var chartZhu = echarts.init(document.getElementById('EchartZhu'));
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: "{{route('index.user.data')}}",
            type: 'POST',
            async: false,
            dataType: "json",
            // 接口成功请求之后的逻辑
            success: function(res) {
                if (res.code == 200) {
                    var optionchartZhe = res.data
                    chartZhu.setOption(optionchartZhe, true);
                }
            },
        });
</script>
@endsection