@extends('admin.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            <!-- 表格头部 -->
            <script type="text/html" id="toolbarDemo">
                <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                    @can('system.permission.create')
                    <div class="layui-inline" lay-event="add"><i class="layui-icon layui-icon-add-1"></i></div>
                    @endcan
                    <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
                </div>
            </script>
            <!-- 操作 -->
            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    @can('system.permission.edit')
                        <a class="layui-btn layui-btn-xs" lay-event="edit">编辑</a>
                    @endcan
                    @can('system.permission.destroy')
                        <a class="layui-btn layui-btn-danger layui-btn-xs" lay-event="del">删除</a>
                    @endcan
                </div>
            </script>
        </div>
    </div>
@endsection

@section('script')
    @can('system.permission')
        <script>
            layui.config({
                base: '/static/admin/layuiadmin/'
            }).extend({
                treetable: 'treetable-lay/treetable'
            }).use(['layer', 'table', 'form', 'treetable'], function () {
                var $ = layui.jquery;
                var layer = layui.layer;
                var form = layui.form;
                var table = layui.table;
                var treetable = layui.treetable;
                //用户表格初始化

                // 渲染表格
                var dataTable = function () {
                    treetable.render({
                        height: 'full-50',
                        toolbar: '#toolbarDemo',
                        treeColIndex: 1,          // treetable新增参数
                        treeSpid: 0,             // treetable新增参数
                        treeIdName: 'id',       // treetable新增参数
                        treePidName: 'parent_id',     // treetable新增参数
                        treeDefaultClose: true,   // treetable新增参数
                        treeLinkage: true,        // treetable新增参数
                        elem: '#dataTable',
                        url: "{{ route('admin.permission.data') }}",
                        where: {model: "permission"},
                        cols: [[ //表头
                            {field: 'id', title: 'ID', sort: true,align: 'center',minWidth: 100}
                            , {field: 'display_name', title: '显示名称',align: 'center',minWidth: 150}
                            , {field: 'name', title: '权限名称',align: 'center',minWidth: 150}
                            , {field: 'route', title: '路由',align: 'center',minWidth: 150}
                            , {
                                field: 'icon_id', title: '图标', templet: function (d) {
                                    return '<i class="layui-icon ' + d.icon + '"></i>';
                                },align: 'center',minWidth: 100
                            }
                            , {field: 'type_name', title: '类型',align: 'center',minWidth: 100}
                            , {field: 'sort', title: '权重',align: 'center',minWidth: 100}
                            , {field: 'created_at', title: '创建时间',align: 'center',minWidth: 200}
                            , {field: 'updated_at', title: '更新时间',align: 'center',minWidth: 200}
                            , {title: '操作',align: 'center',toolbar: '#options',minWidth: 150}
                        ]],
                        // 设置操作高度问题
                        done: function () {
                            //设置工具栏表头高度
                            $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
                            //设置工具栏按钮栏高度
                            $(".layui-table").eq(1).find("tr").each(function(index,ele){
                                $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
                            });
                        }
                    });
                }
                dataTable(); //调用此函数可重新渲染表格

                // 头部工具
                table.on('toolbar(dataTable)', function (obj) {
                    switch (obj.event) {
                        // 添加
                        case 'add':
                            layer.open({
                                type: 2,
                                shade: 0.8,
                                area: ['60%', '90%'],
                                content: "{{route('admin.permission.create')}}"
                            });
                            break;
                        // 批量删除
                        case 'delete':
                            break;
                        // 刷新
                        case 'refresh':
                            dataTable();
                            break;
                        }
                });

                //监听工具条
                table.on('tool(dataTable)', function (obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                    var data = obj.data //获得当前行数据
                        , layEvent = obj.event; //获得 lay-event 对应的值
                    if (layEvent === 'del') {
                        layer.confirm('确认删除吗？', function (index) {
                            layer.close(index)
                            var load = layer.load();
                            $.post("{{ route('admin.permission.destroy') }}", {
                                _method: 'delete',
                                ids: [data.id]
                            }, function (res) {
                                layer.close(load);
                                if (res.code == 200) {
                                    layer.msg(res.msg, {icon: 1, time:500}, function () {
                                        obj.del();
                                    })
                                } else {
                                    layer.msg(res.msg, {icon: 2})
                                }
                            });
                        });
                    } else if (layEvent === 'edit') {
                        layer.open({
                            type: 2,
                            shade: 0.8,
                            area: ['60%', '90%'],
                            content: '{{route("admin.permission.edit")}}?id='+data.id
                        });
                    }
                });
            })
        </script>
    @endcan
@endsection