@extends('admin.base')

@section('content')
<div class="layui-card">
    <div class="layui-card-body">
        <!-- 表格 -->
        <table id="dataTable" lay-filter="dataTable"></table>
        <!-- 盒子奖品图 -->
        <script type="text/html" id="templet_thumb">
            <img class="pimg" src="@{{d.thumb}}" style="width: 45px;height:45px;object-fit: contain;">
        </script>
        <!-- 盒子图 -->
        <script type="text/html" id="templet_avatar">
            <img class="pimg" src="@{{d.userinfo.avatar}}" style="width: 45px;height:45px;border-radius: 25px;object-fit: contain;">
        </script>
        <!-- 表格头部 -->
        <script type="text/html" id="toolbarDemo">
            <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
            </div>
        </script>
        <!-- 操作 -->
        <script type="text/html" id="options">
            <div class="layui-btn-group">
            </div>
        </script>
    </div>

</div>
@endsection

@section('script')
@can('box.log')
<script>
    layui.use(['layer', 'table', 'form','laydate'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;
        var laydate = layui.laydate;
        var util = layui.util;

        //用户表格初始化
        var dataTable = table.render({
            elem: '#dataTable',
            height: 'full-50',
            toolbar: '#toolbarDemo',
            limits: [20,50,100,200,500],
            limit: 20,
            url: "{{ route('box.log.data',request()->all()) }}",
            page: true, //开启分页
            cols: [[ //表头
                    {checkbox: true}, 
                    {field: 'id',title: 'ID',sort: true,align: 'center',minWidth: 100},
                    {field: 'title',title: '盒子标题',align: 'center',minWidth: 200},
                    {field: 'thumb',title: '盒子奖品图',align: 'center',minWidth: 150,templet: "#templet_thumb"},
                    {field: 'markinfo.title',title: '赏类型',align: 'center',minWidth: 150,templet: function(d) {return d.markinfo.title??'';}}, 
                    {field: 'avatar',title: '中奖人头像',align: 'center',minWidth: 150,templet: "#templet_avatar"},
                    {field: 'nickName',title: '中奖人昵称',align: 'center',minWidth: 120,templet: function(d) {return d.userinfo.nickName;}}, 
                    {field: 'created_at',minWidth: 200,title: '中间时间',align: 'center',templet: function(d) {return util.toDateString(d.created_at*1000);}},
                ]],
            // 设置操作高度问题
            done: function () {
                //设置工具栏表头高度
                $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
                //设置工具栏按钮栏高度
                $(".layui-table").eq(1).find("tr").each(function(index,ele){
                    $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
                });
            }
        });

        //日期范围
        laydate.render({
            elem: '#datesection'
            ,range: ['#start_time', '#end_time']
        });

        // 头部工具
        table.on('toolbar(dataTable)', function (obj) {
            switch (obj.event) {
                // 添加
                case 'add':
                    break;
                // 批量删除
                case 'delete':
                    break;
                // 刷新
                case 'refresh':
                    table.reload("dataTable",{page:{curr:$(".layui-laypage-em").next().html()}});
                    break;
                }
        });

        //监听工具条
        table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data,      // data 数据
                layEvent = obj.event; //获得 lay-event 对应的值
            if (layEvent === 'del') {
                // 单挑删除
            } else if (layEvent === 'edit') {
                // 编辑
            }
        });

        //搜索
        $("#searchBtn").click(function() {
            dataTable.reload({
                where: {
                    title: $("#title").val(),
                },
                page: {curr: $(".layui-laypage-em").next().html()}
            })
        })
    })
</script>
@endcan
@endsection