@extends('admin.base')

@section('content')
    <div class="layui-card">

        <div class="layui-card-header layuiadmin-card-header-auto">
            <!-- form -->
            <div class="layui-form">

                <div class="layui-input-inline" style="width:182px;">
                    <select name="city" id="status">
                        <option value="">请选择状态</option>
                        <option value="0" @if(isset(request()->status) && request()->status==0) selected @endif>待处理</option>
                        <option value="1" @if(isset(request()->status) && request()->status==1) selected @endif>已处理</option>
                    </select>
                </div>&emsp;

                <button class="layui-btn layuiadmin-btn-useradmin" id="searchBtn" lay-submit lay-filter="LAY-user-front-search">
                    <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
                </button>
            </div>
        </div>
    
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            <!-- 表格头部 -->
            <script type="text/html" id="toolbarDemo">
                <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                    <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
                </div>
            </script>
            <!-- 图 -->
            <script type="text/html" id="templet_thumb">
                @{{# layui.each(d.thumb, function(index, item){     }}
                <img class="pimg" src="@{{item}}" style="width: 40px;height:40px;object-fit: contain;">
                @{{# });  }}
            </script>
            <!-- 操作 -->
            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    @can('complain.complain.reply')
                    @{{#  if(d.status==0){ }}
                    <a class="layui-btn layui-btn-xs layui-btn-warm"  lay-event="edit">待处理</a>
                    @{{#  }else{ }}
                    <a class="layui-btn layui-btn-xs layui-btn-disabled" disabled>已处理</a>
                    @{{#  } }}
                    @endcan
                </div>
            </script>
        </div>
    </div>
@endsection

@section('script')
@can('complain.complain')
<script>
layui.use(['layer', 'table', 'form','laydate'], function() {
    var $ = layui.jquery;
    var layer = layui.layer;
    var form = layui.form;
    var table = layui.table;
    var laydate = layui.laydate;
    var util = layui.util;

    //用户表格初始化
    var dataTable = table.render({
        elem: '#dataTable',
        height: 'full-130',
        toolbar: '#toolbarDemo',
        limits: [20,50,100,200,500],
        limit: 20,
        url: "{{ route('complain.complain.data',request()->all()) }}",
        page: true, //开启分页
        cols: [[ //表头
                {checkbox: true}, 
                {field: 'id', title: 'ID', sort: true,align: 'center', minWidth: 100,templet: function(d){ return '<i><b>'+d.id+'</b></i>';}},
                {field: 'mobile',title: '手机号',align: 'center',minWidth: 100,templet: function(d){ return '<i><b>'+d.mobile+'</b></i>';}},
                {field: 'title',title: '分类名称',align: 'center',minWidth: 200,templet: function(d){ return '<i><b>'+d.title+'</b></i>';}},
                {field: 'content', title: '内容',align: 'center',minWidth: 400,templet: function(d){ return '<i><b>'+d.content+'</b></i>';}},
                {field: 'thumb', title: '投诉图',align: 'center',minWidth: 300,templet: "#templet_thumb" },
                {field: 'created_at',minWidth: 200,title: '提交时间',align: 'center',templet: function(d) {return util.toDateString(d.created_at*1000);}},
                {title: '操作',align: 'center',toolbar: '#options',minWidth: 150,fixed: 'right'}
            ]],
        // 设置操作高度问题
        done: function () {
            //设置工具栏表头高度
            $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
            //设置工具栏按钮栏高度
            $(".layui-table").eq(1).find("tr").each(function(index,ele){
                $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
            });
        }
    });

    // 头部工具
    table.on('toolbar(dataTable)', function (obj) {
        switch (obj.event) {
            // 添加
            case 'add':
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['60%', '90%'],
                    content: "{{route('complain.complain.reply')}}"
                });
                break;
            // 批量删除
            case 'delete':
                break;
            // 刷新
            case 'refresh':
                dataTable();
                break;
            }
    });

    //监听工具条
    table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
        var data = obj.data,      // data 数据
            layEvent = obj.event; //获得 lay-event 对应的值
        if (layEvent === 'del') {
            
        } else if (layEvent === 'edit') {
            // 编辑
            layer.open({
                type: 2,
                shade: 0.8,
                area: ['60%', '90%'],
                content: "{{route('complain.complain.reply')}}?id="+data.id
            });
        }
    });

    //搜索
    $("#searchBtn").click(function() {
        dataTable.reload({
            where: {
                id: $("#id").val(),
                status: $("#status").val(),
            },
            page: {curr: $(".layui-laypage-em").next().html()}
        })
    })
})
</script>
@endcan
@endsection